/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserIdMapper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserIdMapperLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderImporter.class})
public class CommerceOrderImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderImporter.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserIdMapperLocalService _userIdMapperLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importOrders(File commerceOrdersFile, long scopeGroupId, long userId) throws Exception {
        MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
        JsonParser jsonFactoryParser = mappingJsonFactory.createParser(commerceOrdersFile);
        JsonToken jsonToken = jsonFactoryParser.nextToken();
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new Exception("JSON Array Expected");
        }
        ServiceContext serviceContext = this.getServiceContext(scopeGroupId, userId);
        while (jsonFactoryParser.nextToken() != JsonToken.END_ARRAY) {
            TreeNode treeNode = jsonFactoryParser.readValueAsTree();
            JSONObject jsonObject = this._jsonFactory.createJSONObject(treeNode.toString());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonObject);
            }
            this._importCommerceOrder(jsonObject, serviceContext);
        }
        jsonFactoryParser.close();
    }

    protected ServiceContext getServiceContext(long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    private void _importCommerceOrder(JSONObject jsonObject, ServiceContext serviceContext) throws Exception {
        UserIdMapper userIdMapper;
        block8: {
            String externalUserId = jsonObject.getString("externalUserId");
            String externalSystemType = jsonObject.getString("externalSystemType");
            userIdMapper = null;
            try {
                userIdMapper = this._userIdMapperLocalService.getUserIdMapperByExternalUserId(externalSystemType, externalUserId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Can not find an user Id mapping for: " + externalUserId), (Throwable)exception);
            }
        }
        if (userIdMapper == null) {
            return;
        }
        String externalProductId = jsonObject.getString("externalProductId");
        CProduct cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(externalProductId, serviceContext.getCompanyId());
        if (cProduct == null) {
            return;
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cProduct.getPublishedCPDefinitionId());
        if (cpDefinition == null) {
            return;
        }
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No CPInstances for CPDefinition: " + String.valueOf(cpDefinition.getCPDefinitionId())));
            }
            return;
        }
        long userId = userIdMapper.getUserId();
        AccountEntry accountEntry = this._accountEntryLocalService.fetchPersonAccountEntry(userId);
        if (accountEntry == null) {
            User user = this._userLocalService.getUser(userId);
            accountEntry = this._accountEntryLocalService.addAccountEntry(userId, 0L, user.getFullName(), null, null, user.getEmailAddress(), null, "", "person", 0, serviceContext);
            this._commerceAccountHelper.addAccountEntryUserRel(accountEntry.getAccountEntryId(), user.getUserId(), serviceContext);
        }
        CommerceOrder commerceOrder = this._commerceOrderLocalService.addCommerceOrder(userId, serviceContext.getScopeGroupId(), accountEntry.getAccountEntryId(), 0L, 0L);
        long timestamp = GetterUtil.getLong((String)jsonObject.getString("timestamp"));
        Date createDate = new Date(timestamp * 1000L);
        commerceOrder.setCreateDate(createDate);
        commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        CommerceContext commerceContext = this._commerceContextFactory.create(serviceContext.getCompanyId(), commerceOrder.getGroupId(), serviceContext.getUserId(), commerceOrder.getCommerceOrderId(), accountEntry.getAccountEntryId());
        CPInstance cpInstance = (CPInstance)cpInstances.get(0);
        this._commerceOrderItemLocalService.addCommerceOrderItem(userId, commerceOrder.getCommerceOrderId(), cpInstance.getCPInstanceId(), "", 1, 0L, 1, commerceContext, serviceContext);
    }
}

