/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.initializer.util.internal.CommerceInitializerUtil;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CPOptionCategoriesImporter.class})
public class CPOptionCategoriesImporter {
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<CPOptionCategory> importCPOptionCategories(JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        ArrayList<CPOptionCategory> cpOptionCategories = new ArrayList<CPOptionCategory>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPOptionCategory cpOptionCategory = this._importCPOptionCategory(jsonArray.getJSONObject(i), i, serviceContext);
            cpOptionCategories.add(cpOptionCategory);
        }
        return cpOptionCategories;
    }

    private CPOptionCategory _importCPOptionCategory(JSONObject jsonObject, double defaultPriority, ServiceContext serviceContext) throws PortalException {
        String key = jsonObject.getString("key");
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryLocalService.fetchCPOptionCategory(serviceContext.getCompanyId(), key);
        if (cpOptionCategory != null) {
            return this._cpOptionCategoryLocalService.updateCPOptionCategory(cpOptionCategory.getCPOptionCategoryId(), this._toMap(key, jsonObject, "title"), this._toMap(null, jsonObject, "description"), jsonObject.getDouble("priority", defaultPriority), key);
        }
        return this._cpOptionCategoryLocalService.addCPOptionCategory(serviceContext.getUserId(), this._toMap(key, jsonObject, "title"), this._toMap(null, jsonObject, "description"), jsonObject.getDouble("priority", defaultPriority), key, serviceContext);
    }

    private Map<Locale, String> _toMap(String defaultValue, JSONObject jsonObject, String nodeName) {
        String value = jsonObject.getString(nodeName);
        if (Validator.isBlank((String)value)) {
            if (Validator.isBlank((String)defaultValue)) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(LocaleUtil.getSiteDefault(), CommerceInitializerUtil.getValue(jsonObject, nodeName, defaultValue));
        }
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Map valuesMap = (Map)ObjectMapperUtil.readValue(HashMap.class, (String)value);
        for (Map.Entry entry : valuesMap.entrySet()) {
            map.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), (String)entry.getValue());
        }
        return map;
    }
}

