/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLImporter.class})
public class DLImporter {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importDocuments(JSONArray jsonArray, ClassLoader classLoader, String documentsDependenciesPath, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.fetchUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addDLFileEntries(jsonArray.getJSONObject(i), classLoader, documentsDependenciesPath, userId, scopeGroupId, serviceContext);
        }
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        if (jsonArray == null) {
            jsonArray = this._jsonFactory.createJSONArray("[{\"actionIds\": [\"VIEW\"], \"roleName\": \"Site Member\",\"scope\": 4}]");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("scope");
            String roleName = jsonObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private void _addDLFileEntries(JSONObject jsonObject, ClassLoader classLoader, String documentsDependencyPath, long userId, long scopeGroupId, ServiceContext serviceContext) throws Exception {
        DLFolder dlFolder = this._addDLFolder(jsonObject, userId, scopeGroupId, serviceContext);
        JSONArray dlFileEntriesJSONArray = jsonObject.getJSONArray("files");
        for (int i = 0; i < dlFileEntriesJSONArray.length(); ++i) {
            JSONObject fileJSONObject = dlFileEntriesJSONArray.getJSONObject(i);
            this._addDLFileEntry(fileJSONObject, classLoader, documentsDependencyPath, userId, dlFolder, serviceContext);
        }
    }

    private DLFileEntry _addDLFileEntry(JSONObject jsonObject, ClassLoader classLoader, String documentsDependencyPath, long userId, DLFolder dlFolder, ServiceContext serviceContext) throws Exception {
        DLFileEntry dlFileEntry = null;
        String fileName = jsonObject.getString("fileName");
        if (Validator.isNotNull((String)fileName)) {
            String description = jsonObject.getString("description");
            String title = jsonObject.getString("title");
            Repository repository = this._repositoryLocalService.fetchRepository(dlFolder.getRepositoryId());
            InputStream inputStream = classLoader.getResourceAsStream(documentsDependencyPath + fileName);
            File file = this._file.createTempFile(inputStream);
            FileEntry fileEntry = this._dlAppLocalService.addFileEntry(null, userId, repository.getRepositoryId(), dlFolder.getFolderId(), fileName, MimeTypesUtil.getContentType((File)file), title, "", description, "", file, null, null, serviceContext);
            dlFileEntry = this._dlFileEntryLocalService.getDLFileEntry(fileEntry.getFileEntryId());
            JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
            if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
                this.updatePermissions(dlFileEntry.getCompanyId(), dlFileEntry.getModelClassName(), String.valueOf(dlFileEntry.getFileEntryId()), permissionsJSONArray);
            } else {
                this.updatePermissions(dlFileEntry.getCompanyId(), dlFileEntry.getModelClassName(), String.valueOf(dlFileEntry.getPrimaryKey()), null);
            }
        }
        return dlFileEntry;
    }

    private DLFolder _addDLFolder(JSONObject jsonObject, long userId, long scopeGroupId, ServiceContext serviceContext) throws Exception {
        String description = jsonObject.getString("description");
        String name = jsonObject.getString("name");
        List repositories = this._repositoryLocalService.getGroupRepositories(scopeGroupId);
        Repository repository = (Repository)repositories.get(0);
        DLFolder dlFolder = this._dlFolderLocalService.addFolder(null, userId, scopeGroupId, repository.getRepositoryId(), false, 0L, name, description, false, serviceContext);
        JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
        if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(dlFolder.getCompanyId(), dlFolder.getModelClassName(), String.valueOf(dlFolder.getPrimaryKey()), permissionsJSONArray);
        } else {
            this.updatePermissions(dlFolder.getCompanyId(), dlFolder.getModelClassName(), String.valueOf(dlFolder.getPrimaryKey()), null);
        }
        return dlFolder;
    }
}

