/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormFactoryHelper;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormImporter.class})
public class DDMFormImporter {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormDeserializer _ddmFormDeserializer;
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference
    private DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    @Reference
    private DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importDDMForms(JSONArray jsonArray, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.fetchUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addDDMFormInstance(jsonArray.getJSONObject(i), userId, scopeGroupId, serviceContext);
        }
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        if (jsonArray == null) {
            jsonArray = this._jsonFactory.createJSONArray("[{\"actionIds\": [\"VIEW\", \"ADD_FORM_INSTANCE_RECORD\"],\"roleName\": \"Site Member\", \"scope\": 4}]");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("scope");
            String roleName = jsonObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private void _addDDMFormInstance(JSONObject jsonObject, long userId, long scopeGroupId, ServiceContext serviceContext) throws Exception {
        Locale locale = serviceContext.getLocale();
        HashMap nameMap = HashMapBuilder.put((Object)locale, (Object)jsonObject.getString("name")).build();
        HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)jsonObject.getString("description")).build();
        String jsonForm = jsonObject.getString("ddmStructure");
        String jsonFormSettings = jsonObject.getString("ddmFormSettings");
        DDMStructure ddmStructure = this._createDDMStructure(nameMap, descriptionMap, jsonForm, jsonFormSettings, serviceContext);
        String jsonFormLayout = jsonObject.getString("ddmStructureLayout");
        this._updateDDMStructureLayout(ddmStructure, ddmStructure.getDDMForm(), jsonFormLayout, serviceContext);
        DDMFormValuesDeserializerDeserializeRequest ddmFormValuesDeserializerDeserializeRequest = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)jsonFormSettings, (DDMForm)DDMFormFactory.create(DDMFormInstanceSettings.class)).build();
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._ddmFormValuesDeserializer.deserialize(ddmFormValuesDeserializerDeserializeRequest);
        DDMFormValues settingsDDMFormValues = ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceLocalService.addFormInstance(userId, scopeGroupId, ddmStructure.getStructureId(), (Map)nameMap, (Map)descriptionMap, settingsDDMFormValues, serviceContext);
        JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
        if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(ddmFormInstance.getCompanyId(), ddmFormInstance.getModelClassName(), String.valueOf(ddmFormInstance.getPrimaryKey()), permissionsJSONArray);
        } else {
            this.updatePermissions(ddmFormInstance.getCompanyId(), ddmFormInstance.getModelClassName(), String.valueOf(ddmFormInstance.getPrimaryKey()), null);
        }
    }

    private List<DDMFormFieldValue> _createDDMFormFieldValues(DDMForm ddmForm, String jsonFormSettings) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(jsonFormSettings);
        return TransformUtil.transform((Collection)ddmForm.getDDMFormFields(), formField -> {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(formField.getName());
            UnlocalizedValue unlocalizedValue = new UnlocalizedValue(jsonObject.getString(formField.getName()));
            ddmFormFieldValue.setValue((Value)unlocalizedValue);
            return ddmFormFieldValue;
        });
    }

    private DDMStructure _createDDMStructure(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String jsonForm, String jsonFormSettings, ServiceContext serviceContext) throws Exception {
        jsonForm = StringUtil.replace((String)jsonForm, (String)"[$LOCALE$]", (String)LocaleUtil.toLanguageId((Locale)serviceContext.getLocale()));
        DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)jsonForm).build();
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(ddmFormDeserializerDeserializeRequest);
        DDMForm ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
        DDMFormLayout defaultDDMFormLayout = DDMUtil.getDefaultDDMFormLayout((DDMForm)ddmForm);
        defaultDDMFormLayout.setPaginationMode("");
        long userId = serviceContext.getUserId();
        long groupId = serviceContext.getScopeGroupId();
        DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, 0L, this._classNameLocalService.getClassNameId(DDLRecordSet.class), "", nameMap, descriptionMap, ddmForm, defaultDDMFormLayout, StorageType.DEFAULT.toString(), 1, serviceContext);
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.addRecordSet(userId, groupId, ddmStructure.getStructureId(), null, nameMap, descriptionMap, 10, 2, serviceContext);
        DDMFormFactoryHelper ddmFormFactoryHelper = new DDMFormFactoryHelper(DDLRecordSetSettings.class);
        DDMForm settingsDDMForm = ddmFormFactoryHelper.createDDMForm();
        DDMFormValues ddmFormValues = new DDMFormValues(settingsDDMForm);
        ddmFormValues.setDefaultLocale(serviceContext.getLocale());
        ddmFormValues.addAvailableLocale(serviceContext.getLocale());
        ddmFormValues.setDDMFormFieldValues(this._createDDMFormFieldValues(settingsDDMForm, jsonFormSettings));
        this._ddlRecordSetLocalService.updateRecordSet(ddlRecordSet.getRecordSetId(), ddmFormValues);
        return ddmStructure;
    }

    private void _updateDDMStructureLayout(DDMStructure structure, DDMForm ddmForm, String jsonFormLayout, ServiceContext serviceContext) throws Exception {
        long userId = serviceContext.getUserId();
        DDMFormLayoutDeserializerDeserializeRequest ddmFormLayoutDeserializerDeserializeRequest = DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)jsonFormLayout).build();
        DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = this._ddmFormLayoutDeserializer.deserialize(ddmFormLayoutDeserializerDeserializeRequest);
        DDMFormLayout formLayout = ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
        this._ddmStructureLocalService.updateStructure(userId, structure.getStructureId(), ddmForm, formLayout, serviceContext);
    }
}

