/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceDiscountsImporter.class})
public class CommerceDiscountsImporter {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommerceDiscounts(JSONArray jsonArray, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommerceDiscount(jsonArray.getJSONObject(i), serviceContext);
        }
    }

    private CommerceDiscount _addCommerceDiscount(JSONObject jsonObject, ServiceContext serviceContext) throws Exception {
        String title = jsonObject.getString("title");
        boolean useCouponCode = jsonObject.getBoolean("useCouponCode");
        String couponCode = jsonObject.getString("couponCode");
        boolean usePercentage = jsonObject.getBoolean("usePercentage");
        BigDecimal maximumDiscountAmount = BigDecimal.valueOf(jsonObject.getDouble("maximumDiscountAmount"));
        BigDecimal level1 = BigDecimal.valueOf(jsonObject.getDouble("level1"));
        boolean active = jsonObject.getBoolean("active");
        return this._commerceDiscountLocalService.addCommerceDiscount(serviceContext.getUserId(), title, "categories", useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "unlimited", 0, active, 1, 1, 2019, -1, -1, 0, 0, 0, 0, 0, true, serviceContext);
    }

    private void _importCommerceDiscount(JSONObject jsonObject, ServiceContext serviceContext) throws Exception {
        CommerceDiscount commerceDiscount = this._addCommerceDiscount(jsonObject, serviceContext);
        JSONArray categoriesJSONArray = jsonObject.getJSONArray("categories");
        if (categoriesJSONArray.length() > 0) {
            DynamicQuery dynamicQuery = this._assetCategoryLocalService.dynamicQuery();
            Criterion criterion = RestrictionsFactoryUtil.eq((String)"companyId", (Object)serviceContext.getCompanyId());
            List assetCategories = this._assetCategoryLocalService.dynamicQuery(dynamicQuery.add(criterion));
            block0: for (int i = 0; i < categoriesJSONArray.length(); ++i) {
                String category = categoriesJSONArray.getString(i);
                for (AssetCategory assetCategory : assetCategories) {
                    String name = assetCategory.getName();
                    if (!name.contains(category)) continue;
                    this._commerceDiscountRelLocalService.addCommerceDiscountRel(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName(), assetCategory.getPrimaryKey(), serviceContext);
                    continue block0;
                }
            }
        }
    }
}

