/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.model.CommerceAccountGroupCommerceAccountRel;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.service.CommerceAccountGroupCommerceAccountRelLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelLocalService;
import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.commerce.exception.NoSuchCountryException;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListAccountRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.service.CommerceRegionLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceAccountsImporter.class})
public class CommerceAccountsImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAccountsImporter.class);
    @Reference
    private CommerceAccountGroupCommerceAccountRelLocalService _commerceAccountGroupCommerceAccountRelLocalService;
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceAccountOrganizationRelLocalService _commerceAccountOrganizationRelLocalService;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommercePriceListAccountRelLocalService _commercePriceListAccountRelLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommerceRegionLocalService _commerceRegionLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommerceAccounts(JSONArray jsonArray, ClassLoader classLoader, String dependenciesPath, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommerceAccount(jsonArray.getJSONObject(i), classLoader, dependenciesPath, serviceContext);
        }
    }

    protected CommerceCountry getCommerceCountry(String twoLetterISOCode) throws PortalException {
        DynamicQuery dynamicQuery = this._commerceCountryLocalService.dynamicQuery();
        Property nameProperty = PropertyFactoryUtil.forName((String)"twoLettersISOCode");
        dynamicQuery.add(nameProperty.eq((Object)twoLetterISOCode));
        List commerceCountries = this._commerceCountryLocalService.dynamicQuery(dynamicQuery, 0, 1);
        if (commerceCountries.isEmpty()) {
            throw new NoSuchCountryException("No country exists with two-letter ISO " + twoLetterISOCode);
        }
        return (CommerceCountry)commerceCountries.get(0);
    }

    private void _importCommerceAccount(JSONObject jsonObject, ClassLoader classLoader, String dependenciesPath, ServiceContext serviceContext) throws Exception {
        JSONArray accountGroupsJSONArray;
        JSONArray priceListsJSONArray;
        String relatedOrganization;
        String name = jsonObject.getString("Name");
        CommerceAccount commerceAccount = this._commerceAccountLocalService.fetchCommerceAccountByReferenceCode(serviceContext.getCompanyId(), FriendlyURLNormalizerUtil.normalize((String)name));
        if (commerceAccount != null) {
            return;
        }
        String accountType = jsonObject.getString("AccountType");
        String email = jsonObject.getString("Email");
        String taxId = jsonObject.getString("TaxId");
        int commerceAccountType = 1;
        if (accountType.equals("Business")) {
            commerceAccountType = 2;
        }
        commerceAccount = this._commerceAccountLocalService.addCommerceAccount(name, 0L, email, taxId, commerceAccountType, true, FriendlyURLNormalizerUtil.normalize((String)name), serviceContext);
        String twoLetterISOCode = jsonObject.getString("Country");
        CommerceCountry commerceCountry = this.getCommerceCountry(twoLetterISOCode);
        long commerceRegionId = 0L;
        String regionCode = jsonObject.getString("Region");
        if (!Validator.isBlank((String)regionCode)) {
            try {
                CommerceRegion commerceRegion = this._commerceRegionLocalService.getCommerceRegion(commerceCountry.getCommerceCountryId(), regionCode);
                commerceRegionId = commerceRegion.getCommerceRegionId();
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
        String street1 = jsonObject.getString("Street1");
        String city = jsonObject.getString("City");
        String zip = jsonObject.getString("Zip");
        this._commerceAddressLocalService.addCommerceAddress(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), commerceAccount.getName(), "", street1, "", "", city, zip, commerceRegionId, commerceCountry.getCommerceCountryId(), "", true, true, serviceContext);
        String companyLogo = jsonObject.getString("CompanyLogo");
        if (!Validator.isBlank((String)companyLogo)) {
            String filePath = dependenciesPath + "images/" + companyLogo;
            try (InputStream inputStream = classLoader.getResourceAsStream(filePath);){
                if (inputStream == null) {
                    throw new FileNotFoundException("No file found at " + filePath);
                }
                this._commerceAccountLocalService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), commerceAccount.getName(), true, FileUtil.getBytes((InputStream)inputStream), commerceAccount.getEmail(), commerceAccount.getTaxId(), true, serviceContext);
            }
        }
        if (!Validator.isBlank((String)(relatedOrganization = jsonObject.getString("RelatedOrganization")))) {
            CommerceAccountOrganizationRelPK commerceAccountOrganizationRelPK;
            CommerceAccountOrganizationRel commerceAccountOrganizationRel;
            Organization organization = this._organizationLocalService.fetchOrganization(serviceContext.getCompanyId(), relatedOrganization);
            if (organization == null) {
                organization = this._organizationLocalService.addOrganization(serviceContext.getUserId(), 0L, name, "organization", 0L, 0L, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", false, serviceContext);
            }
            if ((commerceAccountOrganizationRel = this._commerceAccountOrganizationRelLocalService.fetchCommerceAccountOrganizationRel(commerceAccountOrganizationRelPK = new CommerceAccountOrganizationRelPK(commerceAccount.getCommerceAccountId(), organization.getOrganizationId()))) == null) {
                this._commerceAccountOrganizationRelLocalService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organization.getOrganizationId(), serviceContext);
            }
        }
        if ((priceListsJSONArray = jsonObject.getJSONArray("PriceLists")) != null) {
            for (int i = 0; i < priceListsJSONArray.length(); ++i) {
                try {
                    String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)priceListsJSONArray.getString(i));
                    CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
                    if (commercePriceList == null) continue;
                    this._commercePriceListAccountRelLocalService.addCommercePriceListAccountRel(commercePriceList.getCommercePriceListId(), commerceAccount.getCommerceAccountId(), 0, serviceContext);
                    continue;
                }
                catch (NoSuchPriceListException noSuchPriceListException) {
                    _log.error((Object)noSuchPriceListException, (Throwable)noSuchPriceListException);
                }
            }
        }
        if ((accountGroupsJSONArray = jsonObject.getJSONArray("AccountGroups")) != null) {
            for (int i = 0; i < accountGroupsJSONArray.length(); ++i) {
                try {
                    String accountGroupName = accountGroupsJSONArray.getString(i);
                    String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)accountGroupName);
                    CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupLocalService.fetchCommerceAccountGroupByReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
                    if (commerceAccountGroup == null) {
                        commerceAccountGroup = this._commerceAccountGroupLocalService.addCommerceAccountGroup(serviceContext.getCompanyId(), accountGroupName, 2, false, externalReferenceCode, serviceContext);
                    }
                    String relExternalReferenceCode = StringBundler.concat((String[])new String[]{FriendlyURLNormalizerUtil.normalize((String)accountGroupName), "_", FriendlyURLNormalizerUtil.normalize((String)commerceAccount.getName())});
                    CommerceAccountGroupCommerceAccountRel commerceAccountGroupCommerceAccountRel = this._commerceAccountGroupCommerceAccountRelLocalService.fetchCommerceAccountGroupCommerceAccountRelByReferenceCode(serviceContext.getCompanyId(), relExternalReferenceCode);
                    if (commerceAccountGroupCommerceAccountRel != null) continue;
                    this._commerceAccountGroupCommerceAccountRelLocalService.addCommerceAccountGroupCommerceAccountRel(commerceAccountGroup.getCommerceAccountGroupId(), commerceAccount.getCommerceAccountId(), relExternalReferenceCode, serviceContext);
                    continue;
                }
                catch (NoSuchAccountGroupException noSuchAccountGroupException) {
                    _log.error((Object)noSuchAccountGroupException, (Throwable)noSuchAccountGroupException);
                }
            }
        }
    }
}

