/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={AssetTagsImporter.class})
public class AssetTagsImporter {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<AssetTag> importAssetTags(JSONArray jsonArray, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        ArrayList<AssetTag> assetTags = new ArrayList<AssetTag>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            String tagName = jsonArray.getString(i);
            AssetTag assetTag = this._assetTagLocalService.fetchTag(scopeGroupId, tagName);
            if (assetTag == null) {
                assetTag = this._assetTagLocalService.addTag(userId, scopeGroupId, tagName, serviceContext);
            }
            assetTags.add(assetTag);
        }
        return assetTags;
    }
}

