/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.commerce.initializer.util.CPAttachmentFileEntryCreator;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={AssetCategoriesImporter.class})
public class AssetCategoriesImporter {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private CPAttachmentFileEntryCreator _cpAttachmentFileEntryCreator;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<AssetCategory> importAssetCategories(JSONArray jsonArray, String assetVocabularyName, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId) throws Exception {
        return this.importAssetCategories(jsonArray, assetVocabularyName, classLoader, imageDependenciesPath, scopeGroupId, userId, false);
    }

    public List<AssetCategory> importAssetCategories(JSONArray jsonArray, String assetVocabularyName, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId, boolean addGuestPermissions) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        ArrayList<AssetCategory> assetCategories = new ArrayList<AssetCategory>(jsonArray.length());
        AssetVocabulary assetVocabulary = this._addAssetVocabulary(assetVocabularyName, serviceContext);
        this.updateAssetVocabularyPermissions(assetVocabulary);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray permissionsJSONArray;
            String title = null;
            String imageFileName = null;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject != null) {
                title = jsonObject.getString("Title");
                imageFileName = jsonObject.getString("Image");
            } else {
                title = jsonArray.getString(i);
            }
            AssetCategory assetCategory = this._addAssetCategory(assetVocabulary.getVocabularyId(), title, classLoader, imageDependenciesPath, imageFileName, serviceContext);
            assetCategories.add(assetCategory);
            if (jsonObject == null || (permissionsJSONArray = jsonObject.getJSONArray("Permissions")) == null || permissionsJSONArray.length() <= 0) continue;
            this.updatePermissions(assetCategory.getCompanyId(), assetCategory.getModelClassName(), String.valueOf(assetCategory.getCategoryId()), permissionsJSONArray);
        }
        return assetCategories;
    }

    protected void updateAssetVocabularyPermissions(AssetVocabulary assetVocabulary) throws PortalException {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("RoleName", "User").put("Scope", 4);
        JSONArray actionIdsJSONArray = this._jsonFactory.createJSONArray();
        actionIdsJSONArray.put("VIEW");
        jsonObject.put("ActionIds", actionIdsJSONArray);
        jsonArray.put(jsonObject);
        this.updatePermissions(assetVocabulary.getCompanyId(), assetVocabulary.getModelClassName(), String.valueOf(assetVocabulary.getVocabularyId()), jsonArray);
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("Scope");
            String roleName = jsonObject.getString("RoleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("ActionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private AssetCategory _addAssetCategory(long assetVocabularyId, String title, ClassLoader classLoader, String imageDependenciesPath, String imageFileName, ServiceContext serviceContext) throws Exception {
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(serviceContext.getScopeGroupId(), 0L, title, assetVocabularyId);
        if (assetCategory == null) {
            Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), title);
            assetCategory = this._assetCategoryLocalService.addCategory(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, titleMap, null, assetVocabularyId, new String[0], serviceContext);
        }
        Group companyGroup = this._groupLocalService.getCompanyGroup(this._portal.getDefaultCompanyId());
        long classNameId = this._portal.getClassNameId(AssetCategory.class);
        List friendlyURLEntries = this._friendlyURLEntryLocalService.getFriendlyURLEntries(companyGroup.getGroupId(), classNameId, assetCategory.getCategoryId());
        if (friendlyURLEntries.isEmpty()) {
            Map<String, String> urlTitleMap = this._getUniqueUrlTitles(assetCategory);
            this._friendlyURLEntryLocalService.addFriendlyURLEntry(companyGroup.getGroupId(), classNameId, assetCategory.getCategoryId(), urlTitleMap, serviceContext);
        }
        if (Validator.isNotNull((String)imageFileName)) {
            this._cpAttachmentFileEntryCreator.addCPAttachmentFileEntry((ClassedModel)assetCategory, classLoader, imageDependenciesPath, imageFileName, 0.0, 0, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        }
        Role siteMemberRole = this._roleLocalService.getRole(serviceContext.getCompanyId(), "Site Member");
        this._resourcePermissionLocalService.setResourcePermissions(serviceContext.getCompanyId(), AssetCategory.class.getName(), 4, String.valueOf(assetCategory.getCategoryId()), siteMemberRole.getRoleId(), new String[]{"VIEW"});
        return assetCategory;
    }

    private AssetVocabulary _addAssetVocabulary(String name, ServiceContext serviceContext) throws Exception {
        AssetVocabulary assetVocabulary;
        String vocabularyName = name;
        if (name != null) {
            vocabularyName = name.trim();
            vocabularyName = StringUtil.toLowerCase((String)vocabularyName);
        }
        if ((assetVocabulary = this._assetVocabularyLocalService.fetchGroupVocabulary(serviceContext.getScopeGroupId(), vocabularyName)) == null) {
            assetVocabulary = this._assetVocabularyLocalService.addVocabulary(serviceContext.getUserId(), serviceContext.getScopeGroupId(), name, serviceContext);
        }
        Role siteMemberRole = this._roleLocalService.getRole(serviceContext.getCompanyId(), "Site Member");
        this._resourcePermissionLocalService.setResourcePermissions(serviceContext.getCompanyId(), AssetVocabulary.class.getName(), 4, String.valueOf(assetVocabulary.getVocabularyId()), siteMemberRole.getRoleId(), new String[]{"VIEW"});
        return assetVocabulary;
    }

    private Map<String, String> _getUniqueUrlTitles(AssetCategory assetCategory) throws Exception {
        HashMap<String, String> urlTitleMap = new HashMap<String, String>();
        Map titleMap = assetCategory.getTitleMap();
        for (Map.Entry titleEntry : titleMap.entrySet()) {
            Group companyGroup = this._groupLocalService.getCompanyGroup(this._portal.getDefaultCompanyId());
            long classNameId = this._portal.getClassNameId(AssetCategory.class);
            String urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(companyGroup.getGroupId(), classNameId, assetCategory.getCategoryId(), (String)titleEntry.getValue());
            urlTitleMap.put(LocaleUtil.toLanguageId((Locale)((Locale)titleEntry.getKey())), urlTitle);
        }
        return urlTitleMap;
    }
}

