/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.geocoder.bing.internal;

import com.liferay.commerce.exception.CommerceGeocoderException;
import com.liferay.commerce.geocoder.bing.internal.configuration.BingCommerceGeocoderConfiguration;
import com.liferay.commerce.model.CommerceGeocoder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.liferay.commerce.geocoder.bing.internal.configuration.BingCommerceGeocoderConfiguration"}, service={CommerceGeocoder.class})
public class BingCommerceGeocoder
implements CommerceGeocoder {
    private volatile String _apiKey;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private volatile CountryLocalService _countryLocalService;
    @Reference
    private volatile GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private volatile RegionLocalService _regionLocalService;

    public double[] getCoordinates(long groupId, String street, String city, String zip, String regionCode, String countryA2) throws CommerceGeocoderException {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            Country country = this._countryLocalService.getCountryByA2(group.getCompanyId(), countryA2);
            return this._getCoordinates(street, city, zip, this._regionLocalService.getRegion(country.getCountryId(), regionCode), country);
        }
        catch (CommerceGeocoderException commerceGeocoderException) {
            throw commerceGeocoderException;
        }
        catch (Exception exception) {
            throw new CommerceGeocoderException((Throwable)exception);
        }
    }

    public double[] getCoordinates(String street, String city, String zip, Region region, Country country) throws CommerceGeocoderException {
        try {
            return this._getCoordinates(street, city, zip, region, country);
        }
        catch (CommerceGeocoderException commerceGeocoderException) {
            throw commerceGeocoderException;
        }
        catch (Exception exception) {
            throw new CommerceGeocoderException((Throwable)exception);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        BingCommerceGeocoderConfiguration bingCommerceGeocoderConfiguration = (BingCommerceGeocoderConfiguration)ConfigurableUtil.createConfigurable(BingCommerceGeocoderConfiguration.class, properties);
        this._apiKey = bingCommerceGeocoderConfiguration.apiKey();
    }

    @Deactivate
    protected void deactivate() {
        this._apiKey = null;
    }

    private void _addParameter(StringBundler sb, String name, String value) {
        if (Validator.isNull((String)value)) {
            return;
        }
        sb.append(name);
        sb.append('=');
        sb.append(URLCodec.encodeURL((String)value));
        sb.append('&');
    }

    private double[] _getCoordinates(String street, String city, String zip, Region region, Country country) throws Exception {
        if (Validator.isNull((String)this._apiKey)) {
            throw new CommerceGeocoderException("Bing commerce geocoder is not configured properly");
        }
        Http.Options options = new Http.Options();
        options.setLocation(this._getUrl(street, city, zip, region, country));
        String json = this._http.URLtoString(options);
        Http.Response response = options.getResponse();
        int responseCode = response.getResponseCode();
        if (responseCode != 200) {
            throw new CommerceGeocoderException("Bing commerce geocoder returned an error code (" + responseCode + ")");
        }
        String xMsBmWsInfo = response.getHeader("X-MS-BM-WS-INFO");
        if (Validator.isNotNull((String)xMsBmWsInfo) && xMsBmWsInfo.equals("1")) {
            throw new CommerceGeocoderException("Bing commerce geocoder is temporarily unavailable");
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        JSONArray resourceSetsJSONArray = jsonObject.getJSONArray("resourceSets");
        JSONObject resourceSetJSONObject = resourceSetsJSONArray.getJSONObject(0);
        JSONArray resourcesJSONArray = resourceSetJSONObject.getJSONArray("resources");
        if (resourcesJSONArray.length() == 0) {
            throw new CommerceGeocoderException("Bing commerce geocoder did not return any result");
        }
        JSONObject resourceJSONObject = resourcesJSONArray.getJSONObject(0);
        JSONObject pointJSONObject = resourceJSONObject.getJSONObject("point");
        JSONArray coordinatesJSONArray = pointJSONObject.getJSONArray("coordinates");
        return new double[]{coordinatesJSONArray.getDouble(0), coordinatesJSONArray.getDouble(1)};
    }

    private String _getUrl(String street, String city, String zip, Region region, Country country) {
        StringBundler sb = new StringBundler(28);
        sb.append("https://dev.virtualearth.net/REST/v1/Locations?");
        this._addParameter(sb, "key", this._apiKey);
        this._addParameter(sb, "addressLine", street);
        this._addParameter(sb, "locality", city);
        this._addParameter(sb, "postalCode", zip);
        if (region != null) {
            this._addParameter(sb, "adminDistrict", region.getRegionCode());
        }
        if (country != null) {
            this._addParameter(sb, "countryRegion", country.getA2());
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

