/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.wishlist;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.frontend.internal.wishlist.model.WishListItemUpdated;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.CommerceWishListItemService;
import com.liferay.commerce.wish.list.service.CommerceWishListService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceWishListResource.class})
public class CommerceWishListResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceWishListResource.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceWishListItemService _commerceWishListItemService;
    @Reference
    private CommerceWishListService _commerceWishListService;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private Portal _portal;

    @Path(value="/wish-list-item")
    @POST
    @Produces(value={"application/json"})
    public Response addWishListItem(@FormParam(value="commerceAccountId") long commerceAccountId, @FormParam(value="groupId") long groupId, @FormParam(value="productId") long cpDefinitionId, @FormParam(value="skuId") long cpInstanceId, @FormParam(value="options") String options, @Context HttpServletRequest httpServletRequest) {
        WishListItemUpdated wishListItemUpdated = new WishListItemUpdated();
        try {
            long commerceWishListItemCount;
            CommerceContext commerceContext = this._commerceContextFactory.create(this._portal.getCompanyId(httpServletRequest), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), this._portal.getUserId(httpServletRequest), 0L, commerceAccountId);
            httpServletRequest.setAttribute("COMMERCE_CONTEXT", (Object)commerceContext);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceWishListItem.class.getName(), (HttpServletRequest)httpServletRequest);
            serviceContext.setScopeGroupId(groupId);
            CommerceWishList commerceWishList = this._commerceWishListService.getDefaultCommerceWishList(groupId, this._portal.getUserId(httpServletRequest));
            CPCatalogEntry cpCatalogEntry = this._cpDefinitionHelper.getCPCatalogEntry(commerceAccountId, groupId, cpDefinitionId, this._portal.getLocale(httpServletRequest));
            CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
            String cpInstanceUuid = "";
            if (cpInstance != null) {
                cpInstanceUuid = cpInstance.getCPInstanceUuid();
            }
            if ((commerceWishListItemCount = (long)this._commerceWishListItemService.getCommerceWishListItemByContainsCPInstanceCount(commerceWishList.getCommerceWishListId(), cpInstanceUuid)) == 0L) {
                this._commerceWishListItemService.addCommerceWishListItem(commerceAccountId, commerceWishList.getCommerceWishListId(), cpCatalogEntry.getCProductId(), cpInstanceUuid, options, serviceContext);
                wishListItemUpdated.setSuccess(true);
            } else {
                CommerceWishListItem commerceWishListItem = this._commerceWishListItemService.getCommerceWishListItem(commerceWishList.getCommerceWishListId(), cpInstanceUuid, cpCatalogEntry.getCProductId());
                this._commerceWishListItemService.deleteCommerceWishListItem(commerceWishListItem.getCommerceWishListItemId());
                wishListItemUpdated.setSuccess(false);
            }
        }
        catch (Exception exception) {
            wishListItemUpdated.setSuccess(false);
            _log.error((Object)exception, (Throwable)exception);
        }
        return this.getResponse(wishListItemUpdated);
    }

    protected Response getResponse(Object object) {
        if (object == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(object);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Object)jsonProcessingException, (Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

