/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.cart;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.frontend.internal.cart.CommerceCartResourceUtil;
import com.liferay.commerce.frontend.internal.cart.model.Cart;
import com.liferay.commerce.frontend.internal.cart.model.Coupon;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceCartResource.class})
public class CommerceCartResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceCartResource.class);
    @Reference
    private CommerceCartResourceUtil _commerceCartResourceUtil;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderHttpHelper _commerceOrderHttpHelper;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Portal _portal;

    @Path(value="/order/{orderId}/coupon-code/{couponCode}")
    @POST
    @Produces(value={"application/json"})
    public Response applyCouponCode(@PathParam(value="orderId") long commerceOrderId, @PathParam(value="couponCode") String couponCode, @Context HttpServletRequest httpServletRequest) {
        Coupon coupon = null;
        try {
            CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
            CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
            CommerceContext commerceContext = this._commerceContextFactory.create(commerceOrder.getCompanyId(), commerceChannel.getGroupId(), this._portal.getUserId(httpServletRequest), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
            this._commerceOrderService.applyCouponCode(commerceOrder.getCommerceOrderId(), couponCode, commerceContext);
            coupon = new Coupon(couponCode);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            coupon = new Coupon(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this.getResponse(coupon);
    }

    @Path(value="/order/{orderId}/coupon-code")
    @POST
    @Produces(value={"application/json"})
    public Response removeCouponCode(@PathParam(value="orderId") long commerceOrderId, @Context HttpServletRequest httpServletRequest) {
        Coupon coupon = null;
        try {
            CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
            CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
            CommerceContext commerceContext = this._commerceContextFactory.create(commerceOrder.getCompanyId(), commerceChannel.getGroupId(), this._portal.getUserId(httpServletRequest), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
            this._commerceOrderService.applyCouponCode(commerceOrder.getCommerceOrderId(), null, commerceContext);
            coupon = new Coupon("");
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            coupon = new Coupon(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this.getResponse(coupon);
    }

    @Path(value="/cart-item")
    @POST
    @Produces(value={"application/json"})
    public Response updateOrderItem(@FormParam(value="groupId") long groupId, @FormParam(value="languageId") String languageId, @FormParam(value="commerceAccountId") long commerceAccountId, @FormParam(value="quantity") int quantity, @FormParam(value="productId") long cpInstanceId, @FormParam(value="options") String options, @FormParam(value="orderId") long orderId, @Context HttpServletRequest httpServletRequest) {
        Cart cart = null;
        try {
            CommerceContext commerceContext = this._commerceContextFactory.create(this._portal.getCompanyId(httpServletRequest), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), this._portal.getUserId(httpServletRequest), orderId, commerceAccountId);
            httpServletRequest.setAttribute("COMMERCE_CONTEXT", (Object)commerceContext);
            CommerceOrder commerceOrder = this._commerceOrderService.fetchCommerceOrder(orderId);
            if (commerceOrder == null) {
                commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(httpServletRequest);
            }
            if (commerceOrder == null) {
                commerceOrder = this._commerceOrderHttpHelper.addCommerceOrder(httpServletRequest);
            }
            commerceContext = this._commerceContextFactory.create(this._portal.getCompanyId(httpServletRequest), commerceOrder.getGroupId(), this._portal.getUserId(httpServletRequest), commerceOrder.getCommerceOrderId(), commerceAccountId);
            httpServletRequest.setAttribute("COMMERCE_CONTEXT", (Object)commerceContext);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceOrderItem.class.getName(), (HttpServletRequest)httpServletRequest);
            CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.upsertCommerceOrderItem(commerceOrder.getCommerceOrderId(), cpInstanceId, quantity, 0, options, commerceContext, serviceContext);
            cart = this._commerceCartResourceUtil.getCart(commerceOrderItem.getCommerceOrderId(), this._getDetailsURL(commerceOrder, groupId, httpServletRequest), LocaleUtil.fromLanguageId((String)languageId), commerceContext, true);
        }
        catch (Exception exception) {
            cart = exception instanceof CommerceOrderValidatorException ? new Cart(this._getCommerceOrderValidatorResultsMessages((CommerceOrderValidatorException)exception)) : new Cart(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this.getResponse(cart);
    }

    protected Response getResponse(Object object) {
        if (object == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(object);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Object)jsonProcessingException, (Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private String[] _getCommerceOrderValidatorResultsMessages(CommerceOrderValidatorException commerceOrderValidatorException) {
        Object[] errorMessages = new String[]{};
        List commerceOrderValidatorResults = commerceOrderValidatorException.getCommerceOrderValidatorResults();
        for (CommerceOrderValidatorResult commerceOrderValidatorResult : commerceOrderValidatorResults) {
            if (!commerceOrderValidatorResult.hasMessageResult()) continue;
            errorMessages = (String[])ArrayUtil.append((Object[])errorMessages, (Object)commerceOrderValidatorResult.getLocalizedMessage());
        }
        return errorMessages;
    }

    private String _getDetailsURL(CommerceOrder commerceOrder, long siteGroupId, HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL portletURL = this._commerceOrderHttpHelper.getCommerceCartPortletURL(siteGroupId, httpServletRequest, commerceOrder);
        if (portletURL != null) {
            return portletURL.toString();
        }
        return this._portal.getHomeURL(httpServletRequest);
    }
}

