/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.service;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class CommerceCurrencyServiceUtil {
    private static ServiceTracker<CommerceCurrencyService, CommerceCurrencyService> _serviceTracker;

    public static CommerceCurrency addCommerceCurrency(long userId, String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().addCommerceCurrency(userId, code, nameMap, symbol, rate, formatPatternMap, maxFractionDigits, minFractionDigits, roundingMode, primary, priority, active);
    }

    public static void deleteCommerceCurrency(long commerceCurrencyId) throws PortalException {
        CommerceCurrencyServiceUtil.getService().deleteCommerceCurrency(commerceCurrencyId);
    }

    public static CommerceCurrency fetchPrimaryCommerceCurrency(long companyId) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().fetchPrimaryCommerceCurrency(companyId);
    }

    public static List<CommerceCurrency> getCommerceCurrencies(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrencies(companyId, active, start, end, orderByComparator);
    }

    public static List<CommerceCurrency> getCommerceCurrencies(long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrencies(companyId, start, end, orderByComparator);
    }

    public static int getCommerceCurrenciesCount(long companyId) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrenciesCount(companyId);
    }

    public static int getCommerceCurrenciesCount(long companyId, boolean active) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrenciesCount(companyId, active);
    }

    public static CommerceCurrency getCommerceCurrency(long commerceCurrencyId) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrency(commerceCurrencyId);
    }

    public static CommerceCurrency getCommerceCurrency(long companyId, String code) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().getCommerceCurrency(companyId, code);
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceCurrencyServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static CommerceCurrency setActive(long commerceCurrencyId, boolean active) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().setActive(commerceCurrencyId, active);
    }

    public static CommerceCurrency setPrimary(long commerceCurrencyId, boolean primary) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().setPrimary(commerceCurrencyId, primary);
    }

    public static CommerceCurrency updateCommerceCurrency(long commerceCurrencyId, String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        return CommerceCurrencyServiceUtil.getService().updateCommerceCurrency(commerceCurrencyId, code, nameMap, symbol, rate, formatPatternMap, maxFractionDigits, minFractionDigits, roundingMode, primary, priority, active, serviceContext);
    }

    public static void updateExchangeRate(long commerceCurrencyId, String exchangeRateProviderKey) throws PortalException {
        CommerceCurrencyServiceUtil.getService().updateExchangeRate(commerceCurrencyId, exchangeRateProviderKey);
    }

    public static void updateExchangeRates() throws PortalException {
        CommerceCurrencyServiceUtil.getService().updateExchangeRates();
    }

    public static CommerceCurrencyService getService() {
        return (CommerceCurrencyService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CommerceCurrencyService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), CommerceCurrencyService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

