/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workflow.apio.internal.architect.resource;

import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.ItemResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.portal.apio.exception.ValidationException;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.workflow.apio.architect.identifier.WorkflowLogIdentifier;
import com.liferay.workflow.apio.architect.identifier.WorkflowTaskIdentifier;
import com.liferay.workflow.apio.internal.architect.form.AssignToMeForm;
import com.liferay.workflow.apio.internal.architect.form.AssignToUserForm;
import com.liferay.workflow.apio.internal.architect.form.ChangeTransitionForm;
import com.liferay.workflow.apio.internal.architect.form.UpdateDueDateForm;
import com.liferay.workflow.apio.internal.architect.route.AssignToMePostRoute;
import com.liferay.workflow.apio.internal.architect.route.AssignToUserPostRoute;
import com.liferay.workflow.apio.internal.architect.route.ChangeTransitionPostRoute;
import com.liferay.workflow.apio.internal.architect.route.UpdateDueDatePostRoute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ItemResource.class})
public class WorkflowTaskItemResource
implements ItemResource<WorkflowTask, Long, WorkflowTaskIdentifier> {
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;

    public String getName() {
        return "workflow-tasks";
    }

    public ItemRoutes<WorkflowTask, Long> itemRoutes(ItemRoutes.Builder<WorkflowTask, Long> builder) {
        return builder.addGetter(this::_getWorkflowTask, Company.class).addCustomRoute((CustomRoute)new AssignToMePostRoute(), this::_assignToMe, CurrentUser.class, WorkflowTaskIdentifier.class, (credentials, id) -> true, AssignToMeForm::buildForm).addCustomRoute((CustomRoute)new AssignToUserPostRoute(), this::_assignToUser, Company.class, CurrentUser.class, WorkflowTaskIdentifier.class, (credentials, id) -> true, AssignToUserForm::buildForm).addCustomRoute((CustomRoute)new ChangeTransitionPostRoute(), this::_changeTransition, CurrentUser.class, WorkflowTaskIdentifier.class, (credentials, id) -> true, ChangeTransitionForm::buildForm).addCustomRoute((CustomRoute)new UpdateDueDatePostRoute(), this::_updateDueDate, CurrentUser.class, WorkflowTaskIdentifier.class, (credentials, id) -> true, UpdateDueDateForm::buildForm).build();
    }

    public Representor<WorkflowTask> representor(Representor.Builder<WorkflowTask, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("WorkflowTask", new String[0]).identifier(WorkflowTask::getWorkflowTaskId).addBoolean("completed", WorkflowTask::isCompleted)).addDate("dateCompleted", WorkflowTask::getCompletionDate)).addDate("dateCreated", WorkflowTask::getCreateDate)).addDate("dueDate", WorkflowTask::getDueDate)).addNested("object", WorkflowTask::getOptionalAttributes, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("Object", new String[0]).addApplicationRelativeURL("identifier", this::_getResourceURL)).addString("resourceType", this::_getResourceType)).build())).addRelatedCollection("logs", WorkflowLogIdentifier.class).addString("definitionName", WorkflowTask::getWorkflowDefinitionName)).addString("description", WorkflowTask::getDescription)).addString("name", WorkflowTask::getName)).addStringList("transitions", this::_getTaskTransitionsNames)).build();
    }

    private WorkflowTask _assignToMe(Long workflowTaskId, AssignToMeForm assignToMeForm, CurrentUser currentUser) throws WorkflowException {
        return this._workflowTaskManager.assignWorkflowTaskToUser(currentUser.getCompanyId(), currentUser.getUserId(), workflowTaskId.longValue(), currentUser.getUserId(), "", null, null);
    }

    private WorkflowTask _assignToUser(Long workflowTaskId, AssignToUserForm assignToMeForm, Company company, CurrentUser currentUser) throws WorkflowException {
        long assigneeId = assignToMeForm.getAssigneeId();
        return this._workflowTaskManager.assignWorkflowTaskToUser(company.getCompanyId(), currentUser.getUserId(), workflowTaskId.longValue(), assigneeId, "", null, null);
    }

    private WorkflowTask _changeTransition(Long workflowTaskId, ChangeTransitionForm changeTransitionForm, CurrentUser currentUser) throws WorkflowException {
        String transition = changeTransitionForm.getTransition();
        Try.fromFallible(() -> this._getTaskTransitionsNames(this._workflowTaskManager.getWorkflowTask(currentUser.getCompanyId(), workflowTaskId.longValue()))).filter(transitionName -> transitionName.contains(transition)).orElseThrow(() -> new ValidationException("Invalid transition: " + transition));
        return this._workflowTaskManager.completeWorkflowTask(currentUser.getCompanyId(), currentUser.getUserId(), workflowTaskId.longValue(), transition, "", null);
    }

    private String _getResourceType(Map<String, Serializable> optionalAttributes) {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put(BlogsEntry.class.getName(), "BlogPosting");
                this.put(MBDiscussion.class.getName(), "Comment");
            }
        };
        String type = (String)map.get(optionalAttributes.get("entryClassName"));
        if (type == null) {
            return null;
        }
        return type;
    }

    private String _getResourceURL(Map<String, Serializable> optionalAttributes) {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put(BlogsEntry.class.getName(), "blog-posting");
                this.put(MBDiscussion.class.getName(), "comment");
            }
        };
        String entryClassName = (String)map.get(optionalAttributes.get("entryClassName"));
        if (entryClassName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("p/");
        sb.append(entryClassName);
        sb.append("/");
        String entryClassPK = (String)((Object)optionalAttributes.get("entryClassPK"));
        sb.append(entryClassPK);
        return sb.toString();
    }

    private List<String> _getTaskTransitionsNames(WorkflowTask workflowTask) {
        long userId = workflowTask.getAssigneeUserId();
        long workflowTaskId = workflowTask.getWorkflowTaskId();
        return (List)Try.fromFallible(() -> this._userLocalService.getUserById(workflowTask.getAssigneeUserId())).map(UserModel::getCompanyId).map(companyId -> this._workflowTaskManager.getNextTransitionNames(companyId.longValue(), userId, workflowTaskId)).orElse(null);
    }

    private WorkflowTask _getWorkflowTask(long workflowTaskId, Company company) throws WorkflowException {
        return this._workflowTaskManager.getWorkflowTask(company.getCompanyId(), workflowTaskId);
    }

    private WorkflowTask _updateDueDate(Long workflowTaskId, UpdateDueDateForm updateDueDateForm, CurrentUser currentUser) throws WorkflowException {
        return this._workflowTaskManager.updateDueDate(currentUser.getCompanyId(), currentUser.getUserId(), workflowTaskId.longValue(), updateDueDateForm.getComment(), updateDueDateForm.getDueDate());
    }
}

