/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workflow.apio.internal.architect.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.blog.apio.architect.identifier.BlogPostingIdentifier;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.workflow.apio.architect.identifier.WorkflowLogIdentifier;
import com.liferay.workflow.apio.architect.identifier.WorkflowTaskIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowTaskNestedCollectionResource
implements NestedCollectionResource<WorkflowTask, Long, WorkflowTaskIdentifier, Long, PersonIdentifier> {
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;

    public NestedCollectionRoutes<WorkflowTask, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<WorkflowTask, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "workflow-tasks";
    }

    public ItemRoutes<WorkflowTask, Long> itemRoutes(ItemRoutes.Builder<WorkflowTask, Long> builder) {
        return builder.addGetter(this::_getWorkflowTask, Company.class).build();
    }

    public Representor<WorkflowTask> representor(Representor.Builder<WorkflowTask, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("WorkflowTask", new String[0]).identifier(WorkflowTask::getWorkflowTaskId).addBidirectionalModel("assignee", "tasks", PersonIdentifier.class, WorkflowTask::getAssigneeUserId).addBoolean("completed", WorkflowTask::isCompleted)).addDate("dateCompleted", WorkflowTask::getCompletionDate)).addDate("dateCreated", WorkflowTask::getCreateDate)).addDate("expires", WorkflowTask::getDueDate)).addLinkedModel("blogPost", BlogPostingIdentifier.class, this::_getLinkedModelId)).addLinkedModel("comment", CommentIdentifier.class, this::_getLinkedModelId)).addLinkedModel("mediaObject", MediaObjectIdentifier.class, this::_getLinkedModelId)).addRelatedCollection("logs", WorkflowLogIdentifier.class).addString("definitionName", WorkflowTask::getWorkflowDefinitionName)).addString("description", WorkflowTask::getDescription)).addString("name", WorkflowTask::getName)).addStringList("transitions", this::_getTaskTransitionsNames)).build();
    }

    private Serializable _getEntryClassPK(WorkflowTask workflowTask) {
        Map optionalAttributes = workflowTask.getOptionalAttributes();
        return (Serializable)optionalAttributes.get("entryClassPK");
    }

    private Long _getLinkedModelId(WorkflowTask workflowTask) {
        return GetterUtil.getLong((Object)this._getEntryClassPK(workflowTask));
    }

    private PageItems<WorkflowTask> _getPageItems(Pagination pagination, long userId, Company company) throws WorkflowException {
        List workflowTasks = this._workflowTaskManager.getWorkflowTasksByUser(company.getCompanyId(), userId, null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._workflowTaskManager.getWorkflowTaskCountByUser(company.getCompanyId(), userId, null);
        return new PageItems((Collection)workflowTasks, count);
    }

    private List<String> _getTaskTransitionsNames(WorkflowTask workflowTask) {
        long userId = workflowTask.getAssigneeUserId();
        long workflowTaskId = workflowTask.getWorkflowTaskId();
        return (List)Try.fromFallible(() -> this._userLocalService.getUserById(workflowTask.getAssigneeUserId())).map(UserModel::getCompanyId).map(companyId -> this._workflowTaskManager.getNextTransitionNames(companyId.longValue(), userId, workflowTaskId)).orElse(null);
    }

    private WorkflowTask _getWorkflowTask(long workflowTaskId, Company company) throws WorkflowException {
        return this._workflowTaskManager.getWorkflowTask(company.getCompanyId(), workflowTaskId);
    }
}

