Liferay.Loader.define("wiki-web@5.0.92/wiki/js/WikiPortlet.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * WikiPortlet
   *
   * @abstract
   * @extends {Component}
   */
  var WikiPortlet = /*#__PURE__*/function (_PortletBase) {
    _inherits(WikiPortlet, _PortletBase);

    function WikiPortlet() {
      _classCallCheck(this, WikiPortlet);

      return _possibleConstructorReturn(this, _getPrototypeOf(WikiPortlet).apply(this, arguments));
    }

    _createClass(WikiPortlet, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this.eventHandler_ = new _metalEvents.EventHandler();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "attached",
      value: function attached() {
        var _this = this;

        var formatSelect = this.one('#format');

        if (formatSelect) {
          this.currentFormatLabel = formatSelect.options[formatSelect.selectedIndex].text.trim();
          this.currentFormatIndex = formatSelect.selectedIndex;
          this.eventHandler_.add(formatSelect.addEventListener('change', function (e) {
            _this.changeWikiFormat_(e);
          }));
        }

        var publishButton = this.one('#publishButton');

        if (publishButton) {
          this.eventHandler_.add(publishButton.addEventListener('click', function (e) {
            _this.publishPage_(e);
          }));
        }

        var saveButton = this.one('#saveButton');

        if (saveButton) {
          this.eventHandler_.add(saveButton.addEventListener('click', function (e) {
            _this.saveDraft_(e);
          }));
        }

        var searchContainerId = this.ns('pageAttachments');
        Liferay.componentReady(searchContainerId).then(function (searchContainer) {
          _this.eventHandler_.add(searchContainer.get('contentBox').delegate('click', _this.removeAttachment_.bind(_this), '.delete-attachment'));

          _this.searchContainer_ = searchContainer;
        });
      }
      /**
       * Changes the wiki page format. Previously user is informed that she
       * may lose some formatting with a confirm dialog.
       *
       * @protected
       * @param {Event} event The select event that triggered the change action
       */

    }, {
      key: "changeWikiFormat_",
      value: function changeWikiFormat_(event) {
        var formatSelect = event.currentTarget;
        var newFormat = formatSelect.options[formatSelect.selectedIndex].text.trim();
        var confirmMessage = Liferay.Util.sub(this.strings.confirmLoseFormatting, this.currentFormatLabel, newFormat);

        if (confirm(confirmMessage)) {
          this.one('form').setAttribute('action', this.renderUrl);
          this.save_();
        } else {
          formatSelect.selectedIndex = this.currentFormatIndex;
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        _get(_getPrototypeOf(WikiPortlet.prototype), "detached", this).call(this);

        this.eventHandler_.removeAllListeners();
      }
      /**
       * Publish the wiki page.
       *
       * @protected
       */

    }, {
      key: "publishPage_",
      value: function publishPage_() {
        this.one('#workflowAction').value = this.constants.ACTION_PUBLISH;
        this.save_();
      }
      /**
       * Sends a request to remove the selected attachment.
       *
       * @protected
       * @param {Event} event The click event that triggered the remove action
       */

    }, {
      key: "removeAttachment_",
      value: function removeAttachment_(event) {
        var _this2 = this;

        var link = event.currentTarget;
        var deleteURL = link.getAttribute('data-url');
        (0, _frontendJsWeb.fetch)(deleteURL).then(function () {
          var searchContainer = _this2.searchContainer_;
          searchContainer.deleteRow(link.ancestor('tr'), link.getAttribute('data-rowid'));
          searchContainer.updateDataStore();
        });
      }
      /**
       * Checks if there are images that have not been uploaded yet.
       * In that case, it removes them after asking
       * confirmation to the user.
       *
       * @protected
       * @return {Boolean} False if there are temporal images and
       * user does not confirm she wants to lose them. True in other case.
       */

    }, {
      key: "removeTempImages_",
      value: function removeTempImages_() {
        var tempImages = this.all('img[data-random-id]');
        var discardTempImages = true;

        if (tempImages.length > 0) {
          if (confirm(this.strings.confirmDiscardImages)) {
            tempImages.forEach(function (node) {
              node.parentElement.remove();
            });
          } else {
            discardTempImages = false;
          }
        }

        return discardTempImages;
      }
      /**
       * Submits the wiki page.
       *
       * @protected
       */

    }, {
      key: "save_",
      value: function save_() {
        if (this.removeTempImages_()) {
          this.one('#' + this.constants.CMD).value = this.currentAction;
          var titleEditor = window[this.ns('titleEditor')];

          if (titleEditor) {
            this.one('#title').value = titleEditor.getText();
          }

          var contentEditor = window[this.ns('contentEditor')];

          if (contentEditor) {
            this.one('#content').value = contentEditor.getHTML();
          }

          submitForm(document[this.ns('fm')]);
        }
      }
      /**
       * Saves the wiki page as a draft.
       *
       * @protected
       */

    }, {
      key: "saveDraft_",
      value: function saveDraft_() {
        this.one('#workflowAction').value = this.constants.ACTION_SAVE_DRAFT;
        this.save_();
      }
    }]);

    return WikiPortlet;
  }(_frontendJsWeb.PortletBase);
  /**
   * WikiPortlet State definition.
   * @ignore
   * @static
   * @type {!Object}
   */

  WikiPortlet.STATE = {
    /**
     * Portlet's constants
     * @instance
     * @memberof WikiPortlet
     * @type {!Object}
     */
    constants: {
      validator: _metal["default"].isObject
    },

    /**
     * The current action (CMD.ADD, CMD.UPDATE, ...)
     * for the wiki page
     * @instance
     * @memberof WikiPortlet
     * @type {String}
     */
    currentAction: {
      validator: _metal["default"].isString
    },

    /**
     * The render url of the portlet
     * @instance
     * @memberof WikiPortlet
     * @type {String}
     */
    renderUrl: {
      validator: _metal["default"].isString
    },

    /**
     * Portlet's messages
     * @instance
     * @memberof WikiPortlet
     * @type {Object}
     */
    strings: {
      validator: _metal["default"].isObject,
      value: {
        confirmDiscardImages: Liferay.Language.get('uploads-are-in-progress-confirmation'),
        confirmLoseFormatting: Liferay.Language.get('you-may-lose-formatting-when-switching-from-x-to-x')
      }
    }
  };
  var _default = WikiPortlet;
  exports["default"] = _default;
  //# sourceMappingURL=WikiPortlet.es.js.map
});
//# sourceMappingURL=WikiPortlet.es.js.map