Liferay.Loader.define("wiki-web@4.0.7/wiki/js/WikiPortlet.es", ['exports', 'metal/src/metal', 'metal-events/src/events', 'frontend-js-web/liferay/PortletBase.es'], function (exports, _metal, _events, _PortletBase2) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _metal2 = _interopRequireDefault(_metal);

	var _PortletBase3 = _interopRequireDefault(_PortletBase2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var WikiPortlet = function (_PortletBase) {
		_inherits(WikiPortlet, _PortletBase);

		function WikiPortlet() {
			_classCallCheck(this, WikiPortlet);

			return _possibleConstructorReturn(this, (WikiPortlet.__proto__ || Object.getPrototypeOf(WikiPortlet)).apply(this, arguments));
		}

		_createClass(WikiPortlet, [{
			key: 'created',
			value: function created() {
				this.eventHandler_ = new _events.EventHandler();
			}
		}, {
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				var formatSelect = this.one('#format');

				if (formatSelect) {
					this.currentFormatLabel = formatSelect.options[formatSelect.selectedIndex].text.trim();
					this.currentFormatIndex = formatSelect.selectedIndex;

					this.eventHandler_.add(formatSelect.addEventListener('change', function (e) {
						_this2.changeWikiFormat_(e);
					}));
				}

				var publishButton = this.one('#publishButton');

				if (publishButton) {
					this.eventHandler_.add(publishButton.addEventListener('click', function (e) {
						_this2.publishPage_(e);
					}));
				}

				var saveButton = this.one('#saveButton');

				if (saveButton) {
					this.eventHandler_.add(saveButton.addEventListener('click', function (e) {
						_this2.saveDraft_(e);
					}));
				}
			}
		}, {
			key: 'changeWikiFormat_',
			value: function changeWikiFormat_(event) {
				var formatSelect = event.currentTarget;

				var newFormat = formatSelect.options[formatSelect.selectedIndex].text.trim();

				var confirmMessage = _.sub(this.strings.confirmLoseFormatting, this.currentFormatLabel, newFormat);

				if (confirm(confirmMessage)) {
					this.one('form').setAttribute('action', this.renderUrl);
					this.save_();
				} else {
					formatSelect.selectedIndex = this.currentFormatIndex;
				}
			}
		}, {
			key: 'detached',
			value: function detached() {
				_get(WikiPortlet.prototype.__proto__ || Object.getPrototypeOf(WikiPortlet.prototype), 'detached', this).call(this);
				this.eventHandler_.removeAllListeners();
			}
		}, {
			key: 'publishPage_',
			value: function publishPage_() {
				this.one('#workflowAction').value = this.constants.ACTION_PUBLISH;
				this.save_();
			}
		}, {
			key: 'removeTempImages_',
			value: function removeTempImages_() {
				var tempImages = this.all('img[data-random-id]');

				if (tempImages.length > 0) {
					if (confirm(this.strings.confirmDiscardImages)) {
						tempImages.forEach(function (node) {
							node.parentElement.remove();
						});
					} else {
						return false;
					}
				}

				return true;
			}
		}, {
			key: 'save_',
			value: function save_() {
				if (this.removeTempImages_()) {
					this.one('#' + this.constants.CMD).value = this.currentAction;

					var titleEditor = window[this.ns('titleEditor')];

					if (titleEditor) {
						this.one('#title').value = titleEditor.getText();
					}

					var contentEditor = window[this.ns('contentEditor')];

					if (contentEditor) {
						this.one('#content').value = contentEditor.getHTML();
					}

					submitForm(document[this.ns('fm')]);
				}
			}
		}, {
			key: 'saveDraft_',
			value: function saveDraft_() {
				this.one('#workflowAction').value = this.constants.ACTION_SAVE_DRAFT;
				this.save_();
			}
		}]);

		return WikiPortlet;
	}(_PortletBase3.default);

	/**
  * WikiPortlet State definition.
  * @ignore
  * @static
  * @type {!Object}
  */
	WikiPortlet.STATE = {
		/**
   * Portlet's constants
   * @instance
   * @memberof WikiPortlet
   * @type {!Object}
   */
		constants: {
			validator: _metal2.default.isObject
		},

		/**
   * The current action (CMD.ADD, CMD.UPDATE, ...)
   * for the wiki page
   * @instance
   * @memberof WikiPortlet
   * @type {String}
   */
		currentAction: {
			validator: _metal2.default.isString
		},

		/**
   * The render url of the portlet
   * @instance
   * @memberof WikiPortlet
   * @type {String}
   */
		renderUrl: {
			validator: _metal2.default.isString
		},

		/**
   * Portlet's messages
   * @instance
   * @memberof WikiPortlet
   * @type {Object}
   */
		strings: {
			validator: _metal2.default.isObject,
			value: {
				confirmDiscardImages: Liferay.Language.get('uploads-are-in-progress-confirmation'),
				confirmLoseFormatting: Liferay.Language.get('you-may-lose-formatting-when-switching-from-x-to-x')
			}
		}
	};

	exports.default = WikiPortlet;
});
//# sourceMappingURL=WikiPortlet.es.js.map
