/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.util;

import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.WikiFormatException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.util.comparator.PageVersionComparator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class WikiUtil {
    private static ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    private static WikiPageLocalService _wikiPageLocalService;

    public static String getAttachmentURLPrefix(String mainPath, long plid, long nodeId, String title) {
        StringBundler sb = new StringBundler(8);
        sb.append(mainPath);
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(plid);
        sb.append("&nodeId=");
        sb.append(nodeId);
        sb.append("&title=");
        sb.append(URLCodec.encodeURL((String)title));
        sb.append("&fileName=");
        return sb.toString();
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long nodeId, String title, double sourceVersion, double targetVersion, HttpServletRequest request) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List pages = _wikiPageLocalService.getPages(nodeId, title, -1, -1, (OrderByComparator)new PageVersionComparator(true));
        for (WikiPage page : pages) {
            if (page.getVersion() < sourceVersion && page.getVersion() > previousVersion) {
                previousVersion = page.getVersion();
            }
            if (!(page.getVersion() > targetVersion) || !(page.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = page.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (WikiPage page : pages) {
            String extraInfo = "";
            if (page.isMinorEdit()) {
                extraInfo = LanguageUtil.get((HttpServletRequest)request, (String)"minor-edit");
            }
            DiffVersion diffVersion = new DiffVersion(page.getUserId(), page.getVersion(), page.getModifiedDate(), page.getSummary(), extraInfo);
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static String getFormatLabel(WikiEngineRenderer wikiEngineRenderer, String format, Locale locale) {
        WikiEngine wikiEngine = wikiEngineRenderer.fetchWikiEngine(format);
        if (wikiEngine != null) {
            return wikiEngine.getFormatLabel(locale);
        }
        return "";
    }

    public static String getFormattedContent(WikiEngineRenderer wikiEngineRenderer, RenderRequest renderRequest, RenderResponse renderResponse, WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String title, boolean preview) throws Exception {
        WikiPageDisplay pageDisplay;
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
        PortletURL curViewPageURL = PortletURLUtil.clone((PortletURL)viewPageURL, (MimeResponse)renderResponse);
        PortletURL curEditPageURL = PortletURLUtil.clone((PortletURL)editPageURL, (MimeResponse)renderResponse);
        StringBundler sb = new StringBundler(8);
        sb.append(themeDisplay.getPathMain());
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(themeDisplay.getPlid());
        sb.append("&nodeId=");
        sb.append(page.getNodeId());
        sb.append("&title=");
        sb.append(URLCodec.encodeURL((String)page.getTitle()));
        sb.append("&fileName=");
        String attachmentURLPrefix = sb.toString();
        if (!preview && version == 0.0 && (pageDisplay = _wikiPageLocalService.getDisplay(page.getNodeId(), title, curViewPageURL, () -> curEditPageURL, attachmentURLPrefix)) != null) {
            return pageDisplay.getFormattedContent();
        }
        return wikiEngineRenderer.convert(page, curViewPageURL, curEditPageURL, attachmentURLPrefix);
    }

    public static List<WikiNode> getNodes(List<WikiNode> nodes, String[] hiddenNodes, PermissionChecker permissionChecker) throws PortalException {
        nodes = ListUtil.copy(nodes);
        Arrays.sort(hiddenNodes);
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            WikiNode node = (WikiNode)itr.next();
            if (Arrays.binarySearch(hiddenNodes, node.getName()) < 0 && _wikiNodeModelResourcePermission.contains(permissionChecker, (ClassedModel)node, "VIEW")) continue;
            itr.remove();
        }
        return nodes;
    }

    public static List<WikiNode> orderNodes(List<WikiNode> nodes, String[] visibleNodeNames) {
        if (ArrayUtil.isEmpty((Object[])visibleNodeNames)) {
            return nodes;
        }
        nodes = ListUtil.copy(nodes);
        ArrayList<WikiNode> orderedNodes = new ArrayList<WikiNode>(nodes.size());
        block0: for (String visibleNodeName : visibleNodeNames) {
            for (WikiNode node : nodes) {
                String name = node.getName();
                if (!name.equals(visibleNodeName)) continue;
                orderedNodes.add(node);
                nodes.remove(node);
                continue block0;
            }
        }
        orderedNodes.addAll(nodes);
        return orderedNodes;
    }

    public static void renderEditPageHTML(WikiEngineRenderer wikiEngineRenderer, String format, PageContext pageContext, WikiNode node, WikiPage page) throws IOException, ServletException, WikiFormatException {
        WikiEngine wikiEngine = wikiEngineRenderer.fetchWikiEngine(format);
        if (wikiEngine == null) {
            throw new WikiFormatException();
        }
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        wikiEngine.renderEditPage(pageContext.getRequest(), (ServletResponse)pipingServletResponse, node, page);
        JspWriter writer = pageContext.getOut();
        StringBundler sb = unsyncStringWriter.getStringBundler();
        writer.write(sb.toString());
    }

    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<WikiNode> modelResourcePermission) {
        _wikiNodeModelResourcePermission = modelResourcePermission;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        _wikiPageLocalService = wikiPageLocalService;
    }
}

