/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.trash;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.web.internal.asset.WikiPageAssetRenderer;
import com.liferay.wiki.web.internal.trash.BaseWikiTrashHandler;
import com.liferay.wiki.web.internal.util.WikiPageAttachmentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.wiki.model.WikiPage"}, service={TrashHandler.class})
public class WikiPageTrashHandler
extends BaseWikiTrashHandler {
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;
    private WikiEngineRenderer _wikiEngineRenderer;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;
    private WikiPageService _wikiPageService;

    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        return super.addDeletionSystemEvent(userId, groupId, page.getPageId(), classUuid, referrerClassName);
    }

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        this.checkRestorableEntry(classPK, 0L, containerModelId, page.getTitle(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        this._wikiPageLocalService.deletePage(page);
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        return this.getParentContainerModel((TrashedModel)page);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) {
        WikiPage page = (WikiPage)trashedModel;
        if (Validator.isNotNull((String)page.getParentTitle())) {
            try {
                WikiPage parentPage = page.getParentPage();
                while (parentPage.isInTrashImplicitly()) {
                    parentPage = parentPage.getParentPage();
                }
                if (parentPage.isInTrashExplicitly()) {
                    return parentPage;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return page.getNode();
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        containerModels.add(this.getParentContainerModel(classPK));
        return containerModels;
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        WikiNode node = page.getNode();
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", HtmlUtil.unescape((String)page.getTitle()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        WikiNode node = page.getNode();
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        WikiNode node = page.getNode();
        return node.getName();
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getPage(classPK);
        return this._wikiPageLocalService.getChildrenCount(page.getNodeId(), true, page.getTitle(), 8);
    }

    public String getTrashContainerModelName() {
        return "children-pages";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getPage(classPK);
        return this._wikiPageLocalService.getChildrenCount(page.getNodeId(), true, page.getTitle(), 8);
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._wikiPageLocalService.fetchLatestPage(classPK, -1, false);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator obc) throws PortalException {
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        WikiPage page = this._wikiPageLocalService.getPage(classPK);
        List pages = this._wikiPageLocalService.getChildren(page.getNodeId(), true, page.getTitle(), 8, start, end, obc);
        for (WikiPage curPage : pages) {
            trashedModels.add((TrashedModel)curPage);
        }
        return trashedModels;
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        return new WikiPageAssetRenderer(page, this._wikiEngineRenderer, this._trashHelper);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            WikiPage page = this._wikiPageLocalService.fetchLatestPage(classPK, -1, true);
            if (page != null) {
                this._wikiPageModelResourcePermission.check(permissionChecker, (ClassedModel)page, "DELETE");
                classPK = page.getNodeId();
            }
            return this._wikiNodeModelResourcePermission.contains(permissionChecker, classPK, "ADD_PAGE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isMovable() {
        return false;
    }

    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException {
        if (!className.equals(DLFileEntry.class.getName())) {
            return;
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)classPK);
        WikiPage page = WikiPageAttachmentsUtil.getPage(classPK);
        this._wikiPageService.restorePageAttachmentFromTrash(page.getNodeId(), page.getTitle(), fileEntry.getTitle());
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        this._wikiPageLocalService.restorePageFromTrash(userId, page);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        page.setTitle(name);
        this._wikiPageLocalService.updateWikiPage(page);
        WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(page.getResourcePrimKey());
        pageResource.setTitle(name);
        this._wikiPageResourceLocalService.updateWikiPageResource(pageResource);
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        WikiPageResource duplicatePageResource;
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        if (containerModelId == -1L) {
            containerModelId = page.getNodeId();
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicatePageResource = this._wikiPageResourceLocalService.fetchPageResource(containerModelId, originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            WikiPage duplicatePage = this._wikiPageLocalService.getLatestPage(duplicatePageResource.getResourcePrimKey(), -1, false);
            ree.setDuplicateEntryId(duplicatePage.getResourcePrimKey());
            ree.setOldName(duplicatePage.getTitle());
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
        List pages = this._wikiPageLocalService.getDependentPages(page.getNodeId(), true, page.getTitle(), 8);
        for (WikiPage curPage : pages) {
            this.checkRestorableEntry(curPage.getResourcePrimKey(), 0L, containerModelId, curPage.getTitle(), this._trashHelper.getOriginalTitle(curPage.getTitle()));
        }
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean containerModel) throws PortalException {
        Object portletURL = null;
        WikiPage page = this._wikiPageLocalService.getLatestPage(classPK, -1, false);
        long plid = this._portal.getPlidFromPortletId(page.getGroupId(), "com_liferay_wiki_web_portlet_WikiPortlet");
        portletURL = plid == 0L ? this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE") : PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (long)plid, (String)"RENDER_PHASE");
        if (containerModel) {
            portletURL.setParameter("mvcRenderCommandName", "/wiki/view_pages");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._wikiPageModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

