/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.web.internal.asset.WikiNodeTrashRenderer;
import com.liferay.wiki.web.internal.trash.BaseWikiTrashHandler;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.wiki.model.WikiNode"}, service={TrashHandler.class})
public class WikiNodeTrashHandler
extends BaseWikiTrashHandler {
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;
    private WikiNodeLocalService _wikiNodeLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    private WikiPageLocalService _wikiPageLocalService;

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        WikiNode duplicateNode;
        WikiNode node = this._wikiNodeLocalService.getNode(trashEntry.getClassPK());
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateNode = this._wikiNodeLocalService.fetchNode(node.getGroupId(), originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateNode.getNodeId());
            ree.setOldName(duplicateNode.getName());
            ree.setTrashEntryId(trashEntry.getEntryId());
            throw ree;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._wikiNodeLocalService.deleteNode(classPK);
    }

    public String getClassName() {
        return WikiNode.class.getName();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("wiki");
    }

    public String getTrashContainedModelName() {
        return "wiki-pages";
    }

    public int getTrashContainedModelsCount(long classPK) {
        return this._wikiPageLocalService.getPagesCount(classPK, true, 8);
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._wikiNodeLocalService.fetchWikiNode(classPK);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        return this._wikiPageLocalService.getPagesCount(classPK, true, 8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator<?> obc) throws PortalException {
        List pages = this._wikiPageLocalService.getPages(classPK, true, 8, start, end, obc);
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>(pages.size());
        for (WikiPage page : pages) {
            trashedModels.add((TrashedModel)page);
        }
        return trashedModels;
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        return new WikiNodeTrashRenderer(node, this._trashHelper);
    }

    public boolean isContainerModel() {
        return true;
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        this._wikiNodeLocalService.restoreNodeFromTrash(userId, node);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        node.setName(name);
        this._wikiNodeLocalService.updateWikiNode(node);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean containerModel) throws PortalException {
        Object portletURL = null;
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        long plid = this._portal.getPlidFromPortletId(node.getGroupId(), "com_liferay_wiki_web_portlet_WikiPortlet");
        portletURL = plid == 0L ? this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE") : PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (long)plid, (String)"RENDER_PHASE");
        if (!containerModel) {
            portletURL.setParameter("mvcRenderCommandName", "/wiki/view_pages");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._wikiNodeModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

