/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseWikiTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
        if (page == null) {
            return WikiNodeLocalServiceUtil.getNode((long)containerModelId);
        }
        return page;
    }

    public String getContainerModelClassName(long classPK) {
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        catch (Exception e) {
            page = WikiPageLocalServiceUtil.fetchWikiPage((long)classPK);
        }
        try {
            for (WikiPage parentPage = page.getParentPage(); parentPage != null; parentPage = parentPage.getParentPage()) {
                if (!parentPage.isInTrashExplicitly()) continue;
                return WikiPage.class.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WikiNode.class.getName();
    }

    public String getContainerModelName() {
        return "wiki-node";
    }

    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        WikiPage page = null;
        String parentTitle = "";
        if (containerModelId > 0L) {
            page = WikiPageLocalServiceUtil.getPage((long)containerModelId);
            if (page == null) {
                List pages = WikiPageLocalServiceUtil.getPages((long)containerModelId, (int)start, (int)end);
                for (WikiPage curPage : pages) {
                    containerModels.add((ContainerModel)curPage);
                }
                return containerModels;
            }
            parentTitle = page.getTitle();
        } else {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        List pages = WikiPageLocalServiceUtil.getChildren((long)page.getNodeId(), (boolean)true, (String)parentTitle, (int)start, (int)end);
        for (WikiPage curPage : pages) {
            containerModels.add((ContainerModel)curPage);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException {
        WikiPage page = null;
        String parentTitle = "";
        if (containerModelId > 0L) {
            page = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
            if (page == null) {
                return WikiPageLocalServiceUtil.getPagesCount((long)containerModelId);
            }
            parentTitle = page.getTitle();
        } else {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        return WikiPageLocalServiceUtil.getChildrenCount((long)page.getNodeId(), (boolean)true, (String)parentTitle);
    }

    public long getDestinationContainerModelId(long classPK, long destinationContainerModelId) {
        WikiPage page;
        if (destinationContainerModelId == 0L && (page = WikiPageLocalServiceUtil.fetchPage((long)classPK)) != null) {
            return page.getNodeId();
        }
        return destinationContainerModelId;
    }

    public String getSubcontainerModelName() {
        return "wiki-page";
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this.moveTrashEntry(userId, classPK, containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        WikiPage parentPage = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
        if (parentPage == null) {
            WikiPageLocalServiceUtil.movePageFromTrash((long)userId, (long)page.getNodeId(), (String)page.getTitle(), (long)containerModelId, (String)"");
            return;
        }
        WikiPageLocalServiceUtil.movePageFromTrash((long)userId, (long)page.getNodeId(), (String)page.getTitle(), (long)parentPage.getNodeId(), (String)parentPage.getTitle());
    }
}

