/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeServiceUtil;
import com.liferay.wiki.web.internal.security.permission.resource.WikiNodePermission;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class NodesChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(NodesChecker.class);
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PermissionChecker _permissionChecker;

    public NodesChecker(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        super((PortletResponse)liferayPortletResponse);
        this._liferayPortletResponse = liferayPortletResponse;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
    }

    public String getAllRowsCheckBox() {
        return null;
    }

    public String getAllRowsCheckBox(HttpServletRequest request) {
        return null;
    }

    public String getRowCheckBox(HttpServletRequest request, boolean checked, boolean disabled, String primaryKey) {
        boolean showInput;
        String name;
        block7: {
            long nodeId = GetterUtil.getLong((String)primaryKey);
            WikiNode node = null;
            try {
                node = WikiNodeServiceUtil.getNode((long)nodeId);
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe, (Throwable)pe);
                }
                return "";
            }
            name = WikiNode.class.getSimpleName();
            showInput = false;
            try {
                if (WikiNodePermission.contains(this._permissionChecker, node, "DELETE")) {
                    showInput = true;
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        if (!showInput) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append("['");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(WikiNode.class.getSimpleName());
        sb.append("']");
        String checkBoxRowIds = sb.toString();
        return this.getRowCheckBox(request, checked, disabled, StringBundler.concat((String[])new String[]{this._liferayPortletResponse.getNamespace(), "rowIds", name, ""}), primaryKey, checkBoxRowIds, "'#" + this.getAllRowIds() + "'", "");
    }
}

