/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.toolbar.item;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.toolbar.contributor.BasePortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeService;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "mvc.render.command.name=/wiki/view_pages"}, service={WikiPortletToolbarContributor.class, PortletToolbarContributor.class})
public class WikiPortletToolbarContributor
extends BasePortletToolbarContributor {
    private static final Log _log = LogFactoryUtil.getLog(WikiPortletToolbarContributor.class);
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    private WikiNodeService _wikiNodeService;

    protected void addPortletTitleMenuItem(List<MenuItem> menuItems, WikiNode node, ThemeDisplay themeDisplay, PortletRequest portletRequest) throws PortalException {
        if (!this._wikiNodeModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)node, "ADD_PAGE")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("icon-plus-sign-2");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"add-page"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        portletURL.setParameter("title", "");
        portletURL.setParameter("editTitle", "1");
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected List<MenuItem> getPortletTitleMenuItems(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        try {
            WikiNode node = this._getNode(themeDisplay, portletRequest);
            if (node != null) {
                this.addPortletTitleMenuItem(menuItems, node, themeDisplay, portletRequest);
            }
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to add page menu item", (Throwable)pe);
        }
        return menuItems;
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }

    private WikiNode _getNode(ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        WikiNode node = (WikiNode)portletRequest.getAttribute("WIKI_NODE");
        if (node != null) {
            return node;
        }
        String initialNodeName = "";
        try {
            WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)ConfigurationProviderUtil.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(themeDisplay.getScopeGroupId(), "com.liferay.wiki"));
            initialNodeName = wikiGroupServiceOverriddenConfiguration.initialNodeName();
        }
        catch (ConfigurationException ce) {
            _log.error((Object)("Unable to get initial node name for group " + themeDisplay.getScopeGroupId()), (Throwable)ce);
        }
        String name = BeanParamUtil.getString((Object)node, (PortletRequest)portletRequest, (String)"name", (String)initialNodeName);
        if (Validator.isNotNull((String)name)) {
            try {
                node = this._wikiNodeService.getNode(themeDisplay.getScopeGroupId(), name);
            }
            catch (NoSuchNodeException nsne) {
                node = null;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return node;
    }
}

