/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.route;

import com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.escape.WikiEscapeUtil;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"com.liferay.portlet.friendly-url-routes=META-INF/friendly-url-routes/routes.xml", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet"}, service={FriendlyURLMapper.class})
public class WikiFriendlyURLMapper
extends DefaultFriendlyURLMapper {
    private static final String _MAPPING = "wiki";

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        this.addParameter(routeParameters, "nodeName", true);
        this.addParameter(routeParameters, "title", true);
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (Validator.isNull((String)friendlyURLPath)) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        friendlyURLPath = "/".concat(this.getMapping()).concat(friendlyURLPath);
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    protected void addParameter(Map<String, String> routeParameters, String name, boolean escape) {
        if (!routeParameters.containsKey(name)) {
            return;
        }
        String value = routeParameters.get(name);
        value = escape ? WikiEscapeUtil.escapeName((String)value) : WikiEscapeUtil.unescapeName((String)value);
        routeParameters.put(name, value);
    }

    protected void populateParams(Map<String, String[]> parameterMap, String namespace, Map<String, String> routeParameters) {
        this.addParameter(routeParameters, "nodeName", false);
        this.addParameter(routeParameters, "title", false);
        super.populateParams(parameterMap, namespace, routeParameters);
    }
}

