/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.service.WikiNodeService;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "mvc.command.name=/wiki/import_pages"}, service={MVCActionCommand.class})
public class ImportPagesMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(ImportPagesMVCActionCommand.class);
    @Reference
    private Portal _portal;
    private WikiNodeService _wikiNodeService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.importPages(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof PortalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPages(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        String importProgressId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"importProgressId");
        ProgressTracker progressTracker = new ProgressTracker(importProgressId);
        ProgressTrackerThreadLocal.setProgressTracker((ProgressTracker)progressTracker);
        progressTracker.start((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"nodeId");
        String importer = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"importer");
        int filesCount = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"filesCount", (int)10);
        InputStream[] inputStreams = new InputStream[filesCount];
        try {
            for (int i = 0; i < filesCount; ++i) {
                inputStreams[i] = uploadPortletRequest.getFileAsStream("file" + i);
            }
            this._wikiNodeService.importPages(nodeId, importer, inputStreams, actionRequest.getParameterMap());
        }
        finally {
            for (InputStream inputStream : inputStreams) {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
        }
        progressTracker.finish((PortletRequest)actionRequest);
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }
}

