/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.web.internal.util.WikiUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/export_page"}, service={MVCActionCommand.class})
public class ExportPageMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(ExportPageMVCActionCommand.class);
    @Reference
    private Portal _portal;
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiPageService _wikiPageService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        PortletConfig portletConfig = this.getPortletConfig((PortletRequest)actionRequest);
        try {
            long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
            String nodeName = ParamUtil.getString((PortletRequest)actionRequest, (String)"nodeName");
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
            double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            LiferayPortletURL viewPageURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (String)"RENDER_PHASE");
            viewPageURL.setParameter("mvcRenderCommandName", "/wiki/view");
            viewPageURL.setParameter("nodeName", nodeName);
            viewPageURL.setParameter("title", title);
            viewPageURL.setPortletMode(PortletMode.VIEW);
            viewPageURL.setWindowState(WindowState.MAXIMIZED);
            LiferayPortletURL editPageURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (String)"RENDER_PHASE");
            editPageURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
            editPageURL.setParameter("nodeId", String.valueOf(nodeId));
            editPageURL.setParameter("title", title);
            editPageURL.setPortletMode(PortletMode.VIEW);
            editPageURL.setWindowState(WindowState.MAXIMIZED);
            HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
            this.getFile(nodeId, title, version, targetExtension, (PortletURL)viewPageURL, (PortletURL)editPageURL, themeDisplay, request, response);
            actionResponse.setRenderParameter("mvcPath", "/null.jsp");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this._portal.sendError(e, actionRequest, actionResponse);
        }
    }

    protected void getFile(long nodeId, String title, double version, String targetExtension, PortletURL viewPageURL, PortletURL editPageURL, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id;
        File convertedFile;
        WikiPage page = this._wikiPageService.getPage(nodeId, title, version);
        String content = page.getContent();
        String attachmentURLPrefix = WikiUtil.getAttachmentURLPrefix(themeDisplay.getPathMain(), themeDisplay.getPlid(), nodeId, title);
        try {
            content = this._wikiEngineRenderer.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Error formatting the wiki page ", String.valueOf(page.getPageId()), " with the format ", page.getFormat()}), (Throwable)e);
        }
        StringBundler sb = new StringBundler(17);
        sb.append("<!DOCTYPE html>");
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta content=\"");
        sb.append("text/html; charset=UTF-8");
        sb.append("\" http-equiv=\"content-type\" />");
        sb.append("<base href=\"");
        sb.append(themeDisplay.getPortalURL());
        sb.append("\" />");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(title);
        sb.append("</h1>");
        sb.append(content);
        sb.append("</body>");
        sb.append("</html>");
        String s = sb.toString();
        Object is = new UnsyncByteArrayInputStream(s.getBytes("UTF-8"));
        String sourceExtension = "html";
        String fileName = title.concat(".").concat(sourceExtension);
        if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert((String)(id = PrincipalThreadLocal.getUserId() + "_" + page.getUuid()), (InputStream)is, (String)sourceExtension, (String)targetExtension)) != null) {
            fileName = title.concat(".").concat(targetExtension);
            is = new FileInputStream(convertedFile);
        }
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (String)contentType);
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

