/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileMimeTypeException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.dynamic.data.mapping.kernel.StorageFieldRequiredException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.web.internal.WikiAttachmentsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/edit_page_attachment"}, service={MVCActionCommand.class})
public class EditPageAttachmentsMVCActionCommand
extends BaseMVCActionCommand {
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private Portal _portal;
    private WikiAttachmentsHelper _wikiAttachmentsHelper;

    @Reference(unbind="-")
    public void setWikiAttachmentsHelper(WikiAttachmentsHelper wikiAttachmentsHelper) {
        this._wikiAttachmentsHelper = wikiAttachmentsHelper;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    protected void deleteAttachment(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        TrashedModel trashedModel = this._wikiAttachmentsHelper.deleteAttachment(actionRequest, moveToTrash);
        if (moveToTrash && trashedModel != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("cmd", "remove");
            ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
            trashedModels.add(trashedModel);
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        PortletConfig portletConfig = this.getPortletConfig((PortletRequest)actionRequest);
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add")) {
                this._wikiAttachmentsHelper.addAttachments(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest, false);
            } else if (cmd.equals("empty_trash")) {
                this._wikiAttachmentsHelper.emptyTrash(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteAttachment(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this._wikiAttachmentsHelper.restoreEntries(actionRequest);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (PrincipalException | NoSuchNodeException | NoSuchPageException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/wiki/error.jsp");
        }
        catch (Exception e) {
            this.handleUploadException(portletConfig, actionRequest, actionResponse, cmd, e);
        }
    }

    protected String[] getAllowedFileExtensions(PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        return this._dlConfiguration.fileExtensions();
    }

    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String cmd, Exception e) throws Exception {
        if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        } else if (e instanceof AntivirusScannerException || e instanceof DuplicateFileEntryException || e instanceof DuplicateFolderNameException || e instanceof FileExtensionException || e instanceof FileMimeTypeException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException || e instanceof StorageFieldRequiredException || e instanceof UploadRequestSizeException) {
            if (!(cmd.equals("add_dynamic") || cmd.equals("add_multiple") || cmd.equals("add_temp"))) {
                if (e instanceof AntivirusScannerException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
                return;
            }
            if (cmd.equals("add_temp")) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            }
            if (e instanceof AntivirusScannerException || e instanceof DuplicateFileEntryException || e instanceof FileExtensionException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof UploadRequestSizeException) {
                HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
                response.setContentType("text/html");
                response.setStatus(200);
                String errorMessage = "";
                int errorType = 0;
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                if (e instanceof AntivirusScannerException) {
                    AntivirusScannerException ase = (AntivirusScannerException)e;
                    errorMessage = themeDisplay.translate(ase.getMessageKey());
                    errorType = 494;
                }
                if (e instanceof DuplicateFileEntryException) {
                    errorMessage = themeDisplay.translate("please-enter-a-unique-document-name");
                    errorType = 490;
                } else if (e instanceof FileExtensionException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])this.getAllowedFileExtensions(portletConfig, (PortletRequest)actionRequest, (PortletResponse)actionResponse))});
                    errorType = 491;
                } else if (e instanceof FileNameException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
                    errorType = 492;
                } else if (e instanceof FileSizeException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)this._dlValidator.getMaxAllowableSize(), (Locale)themeDisplay.getLocale())});
                    errorType = 493;
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("message", errorMessage);
                jsonObject.put("status", errorType);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            }
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        } else if (e instanceof DuplicateLockException || e instanceof InvalidFileVersionException || e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
            if (e instanceof DuplicateLockException) {
                DuplicateLockException dle = (DuplicateLockException)e;
                SessionErrors.add((PortletRequest)actionRequest, dle.getClass(), (Object)dle.getLock());
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            actionResponse.setRenderParameter("mvcPath", "/html/porltet/document_library/error.jsp");
        } else {
            Throwable cause = e.getCause();
            if (cause instanceof DuplicateFileEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, DuplicateFileEntryException.class);
            } else {
                throw e;
            }
        }
    }
}

