/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.web.internal.portlet.action.ActionUtil;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public abstract class BaseViewPageMVCRenderCommand
implements MVCRenderCommand {
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        long categoryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"categoryId");
        if (categoryId > 0L) {
            return ActionUtil.viewNode(renderRequest, "/wiki/view_categorized_pages.jsp");
        }
        String tag = ParamUtil.getString((PortletRequest)renderRequest, (String)"tag");
        if (Validator.isNotNull((String)tag)) {
            return ActionUtil.viewNode(renderRequest, "/wiki/view_tagged_pages.jsp");
        }
        try {
            WikiNode node = ActionUtil.getNode((PortletRequest)renderRequest);
            renderRequest.setAttribute("WIKI_NODE", (Object)node);
            WikiPage page = ActionUtil.getPage((PortletRequest)renderRequest);
            renderRequest.setAttribute("WIKI_PAGE", (Object)page);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof NoSuchPageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/wiki/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return this.getPath();
    }

    protected void getNode(RenderRequest renderRequest) throws Exception {
        WikiNode node = ActionUtil.getNode((PortletRequest)renderRequest);
        if (node == null) {
            node = ActionUtil.getFirstVisibleNode((PortletRequest)renderRequest);
        }
        renderRequest.setAttribute("WIKI_NODE", (Object)node);
    }

    protected abstract String getPath();
}

