/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/autocomplete_page_title"}, service={MVCResourceCommand.class})
public class AutocompletePageTitleMVCResourceCommand
extends BaseMVCResourceCommand {
    private static final Log _log = LogFactoryUtil.getLog(AutocompletePageTitleMVCResourceCommand.class);
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private BaseSearcher _wikiPageSearcher;

    public void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            JSONArray jsonArray = this.getJSONArray(resourceRequest, resourceResponse);
            HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)resourceResponse);
            response.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)response, (String)jsonArray.toString());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected JSONArray getJSONArray(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        searchContext.setEnd(20);
        String query = ParamUtil.getString((HttpServletRequest)request, (String)"query");
        searchContext.setKeywords(StringUtil.toLowerCase((String)query));
        long nodeId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"nodeId");
        searchContext.setNodeIds(new long[]{nodeId});
        searchContext.setStart(0);
        Hits hits = this._wikiPageSearcher.search(searchContext);
        for (Document document : hits.getDocs()) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("title", document.get("title"));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

