/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.item.selector.resolver;

import com.liferay.item.selector.ItemSelectorReturnTypeResolver;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.escape.WikiEscapeUtil;
import com.liferay.wiki.item.selector.WikiPageURLItemSelectorReturnType;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.web.internal.item.selector.resolver.WikiPageItemSelectorReturnTypeResolver;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={ItemSelectorReturnTypeResolver.class})
public class WikiPageURLItemSelectorReturnTypeResolver
implements WikiPageItemSelectorReturnTypeResolver<WikiPageURLItemSelectorReturnType, WikiPage> {
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public Class<WikiPageURLItemSelectorReturnType> getItemSelectorReturnTypeClass() {
        return WikiPageURLItemSelectorReturnType.class;
    }

    public Class<WikiPage> getModelClass() {
        return WikiPage.class;
    }

    @Override
    public String getTitle(WikiPage page, ThemeDisplay themeDisplay) throws Exception {
        return "";
    }

    public String getValue(WikiPage page, ThemeDisplay themeDisplay) throws Exception {
        String layoutFullURL = this._portal.getLayoutFullURL(page.getGroupId(), "com_liferay_wiki_web_portlet_WikiPortlet");
        if (Validator.isNotNull((String)layoutFullURL)) {
            return StringBundler.concat((String[])new String[]{layoutFullURL, "/-/", "wiki/", String.valueOf(page.getNodeId()), "/", URLCodec.encodeURL((String)WikiEscapeUtil.escapeName((String)page.getTitle()))});
        }
        PortletURL portletURL = this._portal.getControlPanelPortletURL(themeDisplay.getRequest(), "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
        portletURL.setParameter("title", page.getTitle());
        return this._http.removeDomain(portletURL.toString());
    }
}

