/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;

public class WikiSocialActivityHelper {
    private static final Log _log = LogFactoryUtil.getLog(WikiSocialActivityHelper.class);
    private final WikiRequestHelper _wikiRequestHelper;

    public WikiSocialActivityHelper(WikiRequestHelper wikiRequestHelper) {
        this._wikiRequestHelper = wikiRequestHelper;
    }

    public String getSocialActivityActionJSP(SocialActivity socialActivity, JSONObject extraDataJSONObject) throws PortalException {
        int type = socialActivity.getType();
        long fileEntryId = extraDataJSONObject.getLong("fileEntryId");
        FileEntry fileEntry = this._fetchFileEntry(fileEntryId);
        if ((type == 10006 || type == 10009 || type == 10010) && fileEntry != null) {
            return "/wiki/page_activity_attachment_action.jsp";
        }
        if (type == 10008 || type == 1 || type == 2) {
            return "/wiki/page_activity_page_action.jsp";
        }
        return "";
    }

    public String getSocialActivityDescription(WikiPage page, SocialActivity socialActivity, JSONObject extraDataJSONObject, ResourceBundle resourceBundle) throws PortalException {
        int type;
        String userName;
        double version = extraDataJSONObject.getDouble("version", 0.0);
        WikiPage socialActivityWikiPage = null;
        socialActivityWikiPage = version == 0.0 ? WikiPageLocalServiceUtil.fetchPage((long)page.getNodeId(), (String)page.getTitle()) : WikiPageLocalServiceUtil.fetchPage((long)page.getNodeId(), (String)page.getTitle(), (double)version);
        User socialActivityUser = UserLocalServiceUtil.fetchUser((long)socialActivity.getUserId());
        if (socialActivityUser == null) {
            socialActivityUser = UserLocalServiceUtil.getDefaultUser((long)socialActivity.getCompanyId());
        }
        if (Validator.isNull((String)(userName = HtmlUtil.escape((String)socialActivityUser.getFullName())))) {
            userName = "Liferay";
        }
        if ((type = socialActivity.getType()) == 10006 || type == 10009 || type == 10010) {
            String label = "x-added-the-attachment-x";
            if (type == 10009) {
                label = "x-removed-the-attachment-x";
            } else if (type == 10010) {
                label = "x-restored-the-attachment-x";
            }
            String title = extraDataJSONObject.getString("fileEntryTitle");
            long fileEntryId = extraDataJSONObject.getLong("fileEntryId");
            String url = this.getDownloadURL(fileEntryId);
            String titleLink = this.getLink(title, url);
            return LanguageUtil.format((ResourceBundle)resourceBundle, (String)label, (Object[])new Object[]{userName, titleLink}, (boolean)false);
        }
        if (type == 10005) {
            LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            StringBundler sb = new StringBundler(4);
            sb.append(this.getPageURL(page));
            sb.append("#");
            sb.append(liferayPortletResponse.getNamespace());
            sb.append("wikiCommentsPanel");
            return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-added-a-comment", (Object[])new Object[]{userName, sb.toString()}, (boolean)false);
        }
        if (type == 10007 || type == 10008 || type == 1 || type == 2) {
            String pageURL = null;
            pageURL = version == 0.0 ? this.getPageURL(socialActivityWikiPage) : this.getPageURL(socialActivityWikiPage, version);
            if (type == 10007) {
                return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"activity-wiki-page-move-to-trash", (Object[])new Object[]{"", userName, page.getTitle()}, (boolean)false);
            }
            if (type == 10008) {
                String titleLink = this.getLink(page.getTitle(), pageURL);
                return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"activity-wiki-page-restore-from-trash", (Object[])new Object[]{"", userName, titleLink}, (boolean)false);
            }
            if (type == 1) {
                String titleLink = this.getLink(page.getTitle(), pageURL);
                return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-added-the-page-x", (Object[])new Object[]{userName, titleLink}, (boolean)false);
            }
            if (type == 2) {
                String title = String.valueOf(version);
                String url = pageURL;
                if (socialActivityWikiPage != null && socialActivityWikiPage.isMinorEdit()) {
                    title = title + String.format(" (%s)", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"minor-edit"));
                }
                String titleURL = this.getLink(title, url);
                return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-updated-the-page-to-version-x", (Object[])new Object[]{userName, titleURL}, (boolean)false);
            }
            return "";
        }
        return "";
    }

    public String getSocialActivityIcon(SocialActivity socialActivity) {
        int type = socialActivity.getType();
        if (type == 10006) {
            return "icon-paperclip";
        }
        if (type == 10009) {
            return "icon-remove";
        }
        if (type == 10007) {
            return "icon-trash";
        }
        if (type == 10010) {
            return "icon-undo";
        }
        if (type == 10008) {
            return "icon-undo";
        }
        if (type == 1) {
            return "icon-plus";
        }
        if (type == 2) {
            return "icon-edit";
        }
        return "";
    }

    public boolean isSocialActivitySupported(SocialActivity socialActivity) {
        int type = socialActivity.getType();
        return type == 10006 || type == 10005 || type == 10009 || type == 10007 || type == 10010 || type == 10008 || type == 1 || type == 2;
    }

    protected String getDownloadURL(long fileEntryId) throws PortalException {
        FileEntry fileEntry = this._fetchFileEntry(fileEntryId);
        if (fileEntry != null) {
            return PortletFileRepositoryUtil.getDownloadPortletFileEntryURL((ThemeDisplay)this._wikiRequestHelper.getThemeDisplay(), (FileEntry)fileEntry, (String)"");
        }
        return "";
    }

    protected String getLink(String title, String url) {
        if (Validator.isNull((String)url)) {
            return title;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<a href='");
        sb.append(url);
        sb.append("'>");
        sb.append(title);
        sb.append("</a>");
        return sb.toString();
    }

    protected String getPageURL(WikiPage page) {
        if (page == null) {
            return "";
        }
        WikiNode node = page.getNode();
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", page.getTitle());
        return portletURL.toString();
    }

    protected String getPageURL(WikiPage page, double version) {
        if (page == null) {
            return null;
        }
        WikiNode node = page.getNode();
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", page.getTitle());
        portletURL.setParameter("version", String.valueOf(version));
        return portletURL.toString();
    }

    private FileEntry _fetchFileEntry(long fileEntryId) throws PortalException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
            return null;
        }
    }
}

