/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.web.internal.display.context.util.WikiURLHelper;
import com.liferay.wiki.web.internal.portlet.toolbar.item.WikiPortletToolbarContributor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class WikiPagesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final String _displayStyle;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;
    private final SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;
    private final WikiURLHelper _wikiURLHelper;

    public WikiPagesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String displayStyle, SearchContainer searchContainer, TrashHelper trashHelper, WikiURLHelper wikiURLHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._displayStyle = displayStyle;
        this._searchContainer = searchContainer;
        this._trashHelper = trashHelper;
        this._wikiURLHelper = wikiURLHelper;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        this._request = liferayPortletRequest.getHttpServletRequest();
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deletePages");
                    if (WikiPagesManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(WikiPagesManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId())) {
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"move-to-recycle-bin"));
                    } else {
                        dropdownItem.setIcon("times");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"delete"));
                    }
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public PortletURL getClearResultsURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view_pages");
        portletURL.setParameter("redirect", this._currentURLObj.toString());
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all-pages");
        portletURL.setParameter("navigation", navigation);
        WikiNode node = (WikiNode)this._request.getAttribute("WIKI_NODE");
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL;
    }

    public CreationMenu getCreationMenu() {
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            return null;
        }
        WikiPortletToolbarContributor wikiPortletToolbarContributor = (WikiPortletToolbarContributor)((Object)this._request.getAttribute("WIKI_PORTLET_TOOLBAR_CONTRIBUTOR"));
        final List menus = wikiPortletToolbarContributor.getPortletTitleMenus((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        if (menus.isEmpty()) {
            return null;
        }
        return new CreationMenu(){
            {
                for (Menu menu : menus) {
                    List urlMenuItems = menu.getMenuItems();
                    for (URLMenuItem urlMenuItem : urlMenuItems) {
                        this.addDropdownItem(dropdownItem -> {
                            dropdownItem.setHref((Object)urlMenuItem.getURL());
                            dropdownItem.setLabel(urlMenuItem.getLabel());
                        });
                    }
                }
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(WikiPagesManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
                String keywords = ParamUtil.getString((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"keywords");
                if (Validator.isNull((String)keywords)) {
                    this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(WikiPagesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                        dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"order-by"));
                    }));
                }
            }
        };
    }

    public PortletURL getSearchActionURL() {
        PortletURL searchActionURL = this._wikiURLHelper.getSearchURL();
        searchActionURL.setParameter("redirect", this._currentURLObj.toString());
        WikiNode node = (WikiNode)this._request.getAttribute("WIKI_NODE");
        searchActionURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return searchActionURL;
    }

    public String getSortingOrder() {
        return this._getOrderByType();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getPortletURL();
        sortingURL.setParameter("orderByCol", this._getOrderByCol());
        sortingURL.setParameter("orderByType", Objects.equals(this._getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotalItems() {
        return this._searchContainer.getTotal();
    }

    public ViewTypeItemList getViewTypes() {
        return new ViewTypeItemList(this._currentURLObj, this._displayStyle){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabled() {
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all-pages");
        return navigation.equals("all-pages") && !this._searchContainer.hasResults();
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isShowSearch() {
        return true;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() throws PortletException {
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            return null;
        }
        return new DropdownItemList(){
            {
                String navigation = ParamUtil.getString((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)"navigation", (String)"all-pages");
                String[] navigationKeys = new String[]{"all-pages", "draft-pages", "frontpage", "orphan-pages", "recent-changes"};
                PortletURL portletURL = WikiPagesManagementToolbarDisplayContext.this._getPortletURL();
                for (String navigationKey : navigationKeys) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(navigation.equals(navigationKey));
                        PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)WikiPagesManagementToolbarDisplayContext.this._liferayPortletResponse);
                        dropdownItem.setHref(navigationPortletURL, new Object[]{"navigation", navigationKey});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)navigationKey));
                    }));
                }
            }
        };
    }

    private String _getOrderByCol() {
        return this._searchContainer.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() throws PortletException {
        return new DropdownItemList(){
            {
                HashMap<String, String> orderColumns = new HashMap<String, String>();
                orderColumns.put("modifiedDate", "modified-date");
                orderColumns.put("title", "title");
                PortletURL portletURL = WikiPagesManagementToolbarDisplayContext.this._getPortletURL();
                for (Map.Entry orderByColEntry : orderColumns.entrySet()) {
                    String orderByCol = (String)orderByColEntry.getKey();
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(orderByCol.equals(WikiPagesManagementToolbarDisplayContext.this._getOrderByCol()));
                        PortletURL orderByPortletURL = PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)WikiPagesManagementToolbarDisplayContext.this._liferayPortletResponse);
                        dropdownItem.setHref(orderByPortletURL, new Object[]{"orderByCol", orderByCol});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiPagesManagementToolbarDisplayContext.this._request, (String)((String)orderByColEntry.getValue())));
                    }));
                }
            }
        };
    }

    private String _getOrderByType() {
        return this._searchContainer.getOrderByType();
    }

    private PortletURL _getPortletURL() throws PortletException {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view_pages");
        portletURL.setParameter("redirect", this._currentURLObj.toString());
        return portletURL;
    }
}

