/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.convert;

import com.liferay.portal.convert.BaseConvertProcess;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.web.internal.translator.ClassicToCreoleTranslator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConvertProcess.class})
public class WikiCreoleConvertProcess
extends BaseConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(WikiCreoleConvertProcess.class);
    private WikiPageLocalService _wikiPageLocalService;

    public String getDescription() {
        return "convert-wiki-pages-from-classic-wiki-to-creole-format";
    }

    public boolean isEnabled() {
        boolean enabled = false;
        try {
            int pagesCount = this._wikiPageLocalService.getPagesCount("classic_wiki");
            if (pagesCount > 0) {
                enabled = true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return enabled;
    }

    protected void doConvert() throws Exception {
        List pages = this._wikiPageLocalService.getPages("classic_wiki");
        ClassicToCreoleTranslator translator = new ClassicToCreoleTranslator();
        MaintenanceUtil.appendStatus((String)("Converting " + pages.size() + " Wiki pages from Classic Wiki to Creole format"));
        for (int i = 0; i < pages.size(); ++i) {
            if (i > 0 && i % (pages.size() / 4) == 0) {
                MaintenanceUtil.appendStatus((String)((double)i * 100.0 / (double)pages.size() + "%"));
            }
            WikiPage page = (WikiPage)pages.get(i);
            page.setFormat("creole");
            page.setContent(translator.translate(page.getContent()));
            this._wikiPageLocalService.updateWikiPage(page);
        }
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

