/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.web.internal.security.permission.resource.WikiPagePermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WikiPageAssetRenderer
extends BaseJSPAssetRenderer<WikiPage>
implements TrashRenderer {
    public static final String TYPE = "wiki_page";
    private static final Log _log = LogFactoryUtil.getLog(WikiPageAssetRenderer.class);
    private final WikiPage _page;
    private final TrashHelper _trashHelper;
    private final WikiEngineRenderer _wikiEngineRenderer;
    private WikiGroupServiceOverriddenConfiguration _wikiGroupServiceOverriddenConfiguration;

    public static long getClassPK(WikiPage page) {
        if (!(page.isApproved() || page.isDraft() || page.isPending() || page.isInTrash() || page.getVersion() == 1.0)) {
            return page.getPageId();
        }
        return page.getResourcePrimKey();
    }

    @Deprecated
    public WikiPageAssetRenderer(WikiPage page, WikiEngineRenderer wikiEngineRenderer) {
        this(page, wikiEngineRenderer, null);
    }

    public WikiPageAssetRenderer(WikiPage page, WikiEngineRenderer wikiEngineRenderer, TrashHelper trashHelper) {
        this._page = page;
        this._wikiEngineRenderer = wikiEngineRenderer;
        this._trashHelper = trashHelper;
    }

    public WikiPage getAssetObject() {
        return this._page;
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public long getClassPK() {
        return WikiPageAssetRenderer.getClassPK(this._page);
    }

    public String getDiscussionPath() {
        if (this._wikiGroupServiceOverriddenConfiguration == null) {
            try {
                this._wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)ConfigurationProviderUtil.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._page.getGroupId(), "com.liferay.wiki"));
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        if (this._wikiGroupServiceOverriddenConfiguration.pageCommentsEnabled()) {
            return "edit_page_discussion";
        }
        return null;
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._page.getModifiedDate();
    }

    public long getGroupId() {
        return this._page.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/wiki/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        return "com_liferay_wiki_web_portlet_WikiPortlet";
    }

    public int getStatus() {
        return this._page.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        String content = this._page.getContent();
        try {
            content = HtmlUtil.extractText((String)this._wikiEngineRenderer.convert(this._page, null, null, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public String getTitle(Locale locale) {
        if (!this._page.isInTrash()) {
            return this._page.getTitle();
        }
        if (this._trashHelper == null) {
            return this._page.getTitle();
        }
        return this._trashHelper.getOriginalTitle(this._page.getTitle());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/export_page");
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public PortletURL getURLViewDiffs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)"RENDER_PHASE");
        WikiPage previousVersionPage = WikiPageLocalServiceUtil.getPreviousVersionPage((WikiPage)this._page);
        if (previousVersionPage.getVersion() == this._page.getVersion()) {
            return null;
        }
        portletURL.setParameter("mvcRenderCommandName", "/wiki/compare_versions");
        portletURL.setParameter("groupId", String.valueOf(this._page.getGroupId()));
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        portletURL.setParameter("sourceVersion", String.valueOf(previousVersionPage.getVersion()));
        portletURL.setParameter("targetVersion", String.valueOf(this._page.getVersion()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/wiki/find_page", "pageResourcePrimKey", this._page.getResourcePrimKey());
    }

    public long getUserId() {
        return this._page.getUserId();
    }

    public String getUserName() {
        return this._page.getUserName();
    }

    public String getUuid() {
        return this._page.getUuid();
    }

    public boolean hasDeletePermission(PermissionChecker permissionChecker) throws PortalException {
        return WikiPagePermission.contains(permissionChecker, this._page, "DELETE");
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return WikiPagePermission.contains(permissionChecker, this._page, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return WikiPagePermission.contains(permissionChecker, this._page, "VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("WIKI_PAGE", (Object)this._page);
        return super.include(request, response, template);
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }
}

