/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.upload;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.upload.UploadFileEntryHandler;
import com.liferay.wiki.exception.WikiAttachmentMimeTypeException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PageAttachmentWikiUploadFileEntryHandler.class})
public class PageAttachmentWikiUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    @Reference
    private WikiPageService _wikiPageService;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"resourcePrimKey");
        WikiPage page = this._wikiPageService.getPage(resourcePrimKey);
        this._wikiNodeModelResourcePermission.check(themeDisplay.getPermissionChecker(), page.getNodeId(), "ADD_ATTACHMENT");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        String[] mimeTypes = ParamUtil.getParameterValues((HttpServletRequest)uploadPortletRequest, (String)"mimeTypes");
        this._validateFile(fileName, contentType, mimeTypes);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            FileEntry fileEntry = this._wikiPageService.addPageAttachment(page.getNodeId(), page.getTitle(), fileName, inputStream, contentType);
            return fileEntry;
        }
    }

    private void _validateFile(String fileName, String contentType, String[] mimeTypes) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])mimeTypes)) {
            return;
        }
        for (String mimeType : mimeTypes) {
            if (!mimeType.equals(contentType)) continue;
            return;
        }
        throw new WikiAttachmentMimeTypeException(StringBundler.concat((String[])new String[]{"Invalid MIME type ", contentType, " for file name ", fileName}));
    }
}

