/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.social;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet"}, service={SocialActivityInterpreter.class})
public class WikiActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{WikiPage.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(WikiActivityInterpreter.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.wiki.web)")
    private volatile ResourceBundleLoader _resourceBundleLoader;
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getAttachmentTitle(SocialActivity activity, WikiPageResource pageResource, ServiceContext serviceContext) throws Exception {
        int activityType = activity.getType();
        if (activityType == 10006 || activityType == 10009 || activityType == 10010) {
            FileEntry fileEntry;
            String link;
            block4: {
                link = null;
                fileEntry = null;
                try {
                    long fileEntryId = GetterUtil.getLong((String)activity.getExtraDataValue("fileEntryId"));
                    fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
                }
                catch (NoSuchModelException nsme) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)nsme, (Throwable)nsme);
                }
            }
            String fileEntryTitle = activity.getExtraDataValue("fileEntryTitle");
            if (fileEntry != null && !fileEntry.isInTrash()) {
                StringBundler sb = new StringBundler(9);
                sb.append(serviceContext.getPathMain());
                sb.append("/wiki/get_page_attachment?p_l_id=");
                sb.append(serviceContext.getPlid());
                sb.append("&nodeId=");
                sb.append(pageResource.getNodeId());
                sb.append("&title=");
                sb.append(URLCodec.encodeURL((String)pageResource.getTitle()));
                sb.append("&fileName=");
                sb.append(fileEntryTitle);
                link = sb.toString();
            }
            return this.wrapLink(link, fileEntryTitle);
        }
        return "";
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/wiki/find_page?pageResourcePrimKey=" + activity.getClassPK();
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) throws Exception {
        WikiPageResource pageResource = this._wikiPageResourceLocalService.fetchWikiPageResource(activity.getClassPK());
        if (pageResource == null) {
            return null;
        }
        String creatorUserName = this.getUserName(activity.getUserId(), serviceContext);
        title = this.wrapLink(link, title);
        return new Object[]{groupName, creatorUserName, title, this.getAttachmentTitle(activity, pageResource, serviceContext)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 3 || activityType == 10005) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-comment";
            }
            return "activity-wiki-page-add-comment-in";
        }
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-page";
            }
            return "activity-wiki-page-add-page-in";
        }
        if (activityType == 10006) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-attachment";
            }
            return "activity-wiki-page-add-attachment-in";
        }
        if (activityType == 10009) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-remove-attachment";
            }
            return "activity-wiki-page-remove-attachment-in";
        }
        if (activityType == 10010) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-restore-attachment";
            }
            return "activity-wiki-page-restore-attachment-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-move-to-trash";
            }
            return "activity-wiki-page-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-restore-from-trash";
            }
            return "activity-wiki-page-restore-from-trash-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-update-page";
            }
            return "activity-wiki-page-update-page-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        if (!this._wikiPageModelResourcePermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return false;
        }
        int activityType = activity.getType();
        if (activityType == 2) {
            WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(activity.getClassPK());
            double version = GetterUtil.getDouble((String)activity.getExtraDataValue("version"));
            WikiPage page = this._wikiPageLocalService.getPage(pageResource.getNodeId(), pageResource.getTitle(), version);
            if (!page.isApproved() && !this._wikiPageModelResourcePermission.contains(permissionChecker, activity.getClassPK(), "UPDATE")) {
                return false;
            }
        }
        return true;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }
}

