/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.BasePermissionPropagator;
import com.liferay.portal.kernel.security.permission.PermissionPropagator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.List;
import javax.portlet.ActionRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet"}, service={PermissionPropagator.class})
public class WikiPermissionPropagatorImpl
extends BasePermissionPropagator {
    private WikiPageLocalService _wikiPageLocalService;

    public void propagateRolePermissions(ActionRequest actionRequest, String className, String primKey, long[] roleIds) throws PortalException {
        if (!className.equals(WikiNode.class.getName())) {
            return;
        }
        long nodeId = GetterUtil.getLong((String)primKey);
        List wikiPages = this._wikiPageLocalService.getPages(nodeId, -1, -1);
        for (WikiPage wikiPage : wikiPages) {
            for (long roleId : roleIds) {
                this.propagateRolePermissions(actionRequest, roleId, WikiNode.class.getName(), nodeId, WikiPage.class.getName(), wikiPage.getResourcePrimKey());
            }
        }
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

