/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.configuration.icon;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import com.liferay.wiki.web.internal.portlet.action.ActionUtil;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "path=/wiki/view"}, service={PortletConfigurationIcon.class})
public class PageSubscriptionPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private Portal _portal;
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;

    public String getMessage(PortletRequest portletRequest) {
        String key = "subscribe";
        try {
            WikiPage page = ActionUtil.getPage(portletRequest);
            if (this.isSubscribed(portletRequest, page)) {
                key = "unsubscribe";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            WikiPage page = ActionUtil.getPage(portletRequest);
            PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "ACTION_PHASE");
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_page");
            if (this.isSubscribed(portletRequest, page)) {
                portletURL.setParameter("cmd", "unsubscribe");
            } else {
                portletURL.setParameter("cmd", "subscribe");
            }
            portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
            portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
            portletURL.setParameter("title", page.getTitle());
            return portletURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public double getWeight() {
        return 101.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        HttpServletRequest request = this._portal.getHttpServletRequest(portletRequest);
        WikiRequestHelper wikiRequestHelper = new WikiRequestHelper(request);
        WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = wikiRequestHelper.getWikiGroupServiceOverriddenConfiguration();
        try {
            WikiPage page = ActionUtil.getPage(portletRequest);
            if (this._wikiPageModelResourcePermission.contains(wikiRequestHelper.getPermissionChecker(), (ClassedModel)page, "SUBSCRIBE") && (wikiGroupServiceOverriddenConfiguration.emailPageAddedEnabled() || wikiGroupServiceOverriddenConfiguration.emailPageUpdatedEnabled())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean isSubscribed(PortletRequest portletRequest, WikiPage page) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._subscriptionLocalService.isSubscribed(themeDisplay.getCompanyId(), themeDisplay.getUserId(), WikiNode.class.getName(), page.getNodeId());
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }
}

