/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.configuration.icon;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.web.internal.portlet.action.ActionUtil;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "path=/wiki/view_pages"}, service={PortletConfigurationIcon.class})
public class DeleteNodePortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    private WikiNodeService _wikiNodeService;

    public String getMessage(PortletRequest portletRequest) {
        String key = "delete";
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
            key = "move-to-recycle-bin";
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            WikiNode node = ActionUtil.getNode(portletRequest);
            PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "ACTION_PHASE");
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_node");
            if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
                portletURL.setParameter("cmd", "move_to_trash");
            } else {
                portletURL.setParameter("cmd", "delete");
            }
            PortletURL viewNodesURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE");
            viewNodesURL.setParameter("mvcRenderCommandName", "/wiki_admin/view");
            portletURL.setParameter("redirect", viewNodesURL.toString());
            portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
            return portletURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            WikiNode node = ActionUtil.getNode(portletRequest);
            if (this._wikiNodeModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)node, "DELETE") && this._wikiNodeService.getNodesCount(themeDisplay.getScopeGroupId()) > 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean isTrashEnabled(long groupId) {
        try {
            if (this._trashHelper.isTrashEnabled(groupId)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }
}

