/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.web.internal.util.WikiWebComponentProvider;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/", "mvc.command.name=/wiki_display/view"}, service={MVCRenderCommand.class})
public class WikiDisplayViewMVCRenderCommand
implements MVCRenderCommand {
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiNodeService _wikiNodeService;
    private WikiPageService _wikiPageService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            PortletPreferences portletPreferences = renderRequest.getPreferences();
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
            WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
            String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title", (String)portletPreferences.getValue("title", wikiGroupServiceConfiguration.frontPageName()));
            double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
            WikiNode node = this.getNode(renderRequest);
            if (node.getGroupId() != themeDisplay.getScopeGroupId()) {
                throw new NoSuchNodeException("{nodeId=" + node.getNodeId() + "}");
            }
            WikiPage page = this._wikiPageService.fetchPage(node.getNodeId(), title, version);
            if (page == null || page.isInTrash()) {
                page = this._wikiPageService.getPage(node.getNodeId(), wikiGroupServiceConfiguration.frontPageName());
            }
            renderRequest.setAttribute("WIKI_ENGINE_RENDERER", (Object)this._wikiEngineRenderer);
            renderRequest.setAttribute("WIKI_NODE", (Object)node);
            renderRequest.setAttribute("WIKI_PAGE", (Object)page);
            return "/wiki_display/view.jsp";
        }
        catch (NoSuchNodeException nsne) {
            return "/wiki_display/portlet_not_setup.jsp";
        }
        catch (NoSuchPageException nspe) {
            return "/wiki_display/portlet_not_setup.jsp";
        }
        catch (PortalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, ((Object)((Object)pe)).getClass());
            return "/wiki/error.jsp";
        }
    }

    protected WikiNode getNode(RenderRequest renderRequest) throws PortalException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String nodeName = ParamUtil.getString((PortletRequest)renderRequest, (String)"nodeName");
        if (Validator.isNotNull((String)nodeName)) {
            return this._wikiNodeService.getNode(themeDisplay.getScopeGroupId(), nodeName);
        }
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        return this._wikiNodeService.getNode(nodeId);
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

