/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.BaseRSSStrutsAction;
import com.liferay.rss.util.RSSUtil;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import com.liferay.wiki.web.internal.util.WikiUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/wiki/rss"}, service={StrutsAction.class})
public class RSSAction
extends BaseRSSStrutsAction {
    @Reference
    private Portal _portal;
    private WikiPageService _wikiPageService;

    protected byte[] getRSS(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String rss = "";
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        if (nodeId <= 0L) {
            return rss.getBytes("UTF-8");
        }
        String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
        int max = ParamUtil.getInteger((HttpServletRequest)request, (String)"max", (int)SearchContainer.DEFAULT_DELTA);
        String type = ParamUtil.getString((HttpServletRequest)request, (String)"type", (String)RSSUtil.FORMAT_DEFAULT);
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version", (double)RSSUtil.VERSION_DEFAULT);
        String displayStyle = ParamUtil.getString((HttpServletRequest)request, (String)"displayStyle", (String)RSSUtil.DISPLAY_STYLE_DEFAULT);
        String layoutFullURL = this._portal.getLayoutFullURL(themeDisplay.getScopeGroupId(), "com_liferay_wiki_web_portlet_WikiPortlet");
        StringBundler sb = new StringBundler(4);
        sb.append(layoutFullURL);
        sb.append("/-/");
        sb.append("wiki/");
        sb.append(nodeId);
        String feedURL = sb.toString();
        String entryURL = feedURL + "/" + title;
        String attachmentURLPrefix = WikiUtil.getAttachmentURLPrefix(themeDisplay.getPathMain(), themeDisplay.getPlid(), nodeId, title);
        rss = Validator.isNotNull((String)title) ? this._wikiPageService.getPagesRSS(nodeId, title, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, themeDisplay.getLocale()) : this._wikiPageService.getNodePagesRSS(nodeId, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix);
        return rss.getBytes("UTF-8");
    }

    protected boolean isRSSFeedsEnabled(HttpServletRequest request) throws Exception {
        WikiRequestHelper wikiRequestHelper = new WikiRequestHelper(request);
        WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = wikiRequestHelper.getWikiGroupServiceOverriddenConfiguration();
        return wikiGroupServiceOverriddenConfiguration.enableRss();
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

