/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.exception.DuplicatePageException;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.PageTitleException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/move_page"}, service={MVCActionCommand.class})
public class MovePageMVCActionCommand
extends BaseMVCActionCommand {
    private WikiPageService _wikiPageService;

    protected void changeParentPage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String newParentTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"newParentTitle");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        this._wikiPageService.changeParent(nodeId, title, newParentTitle, serviceContext);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("change_parent")) {
                this.changeParentPage(actionRequest);
            } else if (cmd.equals("rename")) {
                this.renamePage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof NoSuchPageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof DuplicatePageException || e instanceof PageContentException || e instanceof PageTitleException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    protected void renamePage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String newTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"newTitle");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        this._wikiPageService.renamePage(nodeId, title, newTitle, serviceContext);
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

