/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/wiki/get_page_attachment"}, service={StrutsAction.class})
public class GetPageAttachmentAction
extends BaseStrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(GetPageAttachmentAction.class);
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;
    private WikiPageService _wikiPageService;

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
            String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
            String fileName = ParamUtil.getString((HttpServletRequest)request, (String)"fileName");
            if (fileName.startsWith("SharedImages/")) {
                String[] fileNameParts = fileName.split("SharedImages/");
                fileName = fileNameParts[1];
                title = "SharedImages";
            }
            int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)0);
            this.getFile(nodeId, title, fileName, status, request, response);
            return null;
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException || e instanceof NoSuchPageException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
            } else {
                this._portal.sendError(e, request, response);
            }
            return null;
        }
    }

    protected void getFile(long nodeId, String title, String fileName, int status, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream is;
        FlashMagicBytesUtil.Result flashMagicBytesUtilResult;
        WikiPage wikiPage = this._wikiPageService.getPage(nodeId, title);
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)wikiPage.getGroupId(), (long)wikiPage.getAttachmentsFolderId(), (String)fileName);
        if (status != 8 && fileEntry.isInTrash()) {
            return;
        }
        if (fileEntry.isInTrash()) {
            fileName = this._trashHelper.getOriginalTitle(fileEntry.getTitle());
        }
        if ((flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)(is = fileEntry.getContentStream()))).isFlash()) {
            fileName = FileUtil.stripExtension((String)fileName) + ".swf";
        }
        is = flashMagicBytesUtilResult.getInputStream();
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)fileEntry.getSize(), (String)fileEntry.getMimeType());
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

