/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.FindStrutsAction;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/wiki/find_page"}, service={StrutsAction.class})
public class FindPageAction
extends FindStrutsAction {
    private WikiNodeLocalService _wikiNodeLocalService;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;

    protected long getGroupId(long primaryKey) throws Exception {
        WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(primaryKey);
        WikiNode node = this._wikiNodeLocalService.getNode(pageResource.getNodeId());
        return node.getGroupId();
    }

    protected String getPrimaryKeyParameterName() {
        return "pageResourcePrimKey";
    }

    protected String getStrutsAction(HttpServletRequest request, String portletId) {
        if (portletId.equals("com_liferay_wiki_web_portlet_WikiPortlet") || portletId.equals("com_liferay_wiki_web_portlet_WikiAdminPortlet")) {
            return "/wiki/view";
        }
        return "/wiki_display/view";
    }

    protected String[] initPortletIds() {
        return new String[]{"com_liferay_wiki_web_portlet_WikiAdminPortlet", "com_liferay_wiki_web_portlet_WikiPortlet", "com_liferay_wiki_web_portlet_WikiDisplayPortlet"};
    }

    protected PortletURL processPortletURL(HttpServletRequest request, PortletURL portletURL) throws Exception {
        long pageResourcePrimKey = ParamUtil.getLong((HttpServletRequest)request, (String)this.getPrimaryKeyParameterName());
        WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(pageResourcePrimKey);
        WikiNode node = this._wikiNodeLocalService.getNode(pageResource.getNodeId());
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", pageResource.getTitle());
        return portletURL;
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }
}

