/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.DuplicatePageException;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.exception.PageTitleException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import com.liferay.wiki.web.internal.portlet.action.ActionUtil;
import com.liferay.wiki.web.internal.util.WikiWebComponentProvider;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/edit_page"}, service={MVCRenderCommand.class})
public class EditPageMVCRenderCommand
implements MVCRenderCommand {
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiPageService _wikiPageService;
    private WikiPageTitleValidator _wikiPageTitleValidator;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        block4: {
            try {
                renderRequest.setAttribute("WIKI_ENGINE_RENDERER", (Object)this._wikiEngineRenderer);
                renderRequest.setAttribute("WIKI_PAGE_TITLE_VALIDATOR", (Object)this._wikiPageTitleValidator);
                WikiNode node = ActionUtil.getNode((PortletRequest)renderRequest);
                renderRequest.setAttribute("WIKI_NODE", (Object)node);
                if (!SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicatePageException.class.getName())) {
                    this.getPage(renderRequest);
                }
            }
            catch (Exception e) {
                if (e instanceof NoSuchNodeException || e instanceof PageTitleException || e instanceof PrincipalException) {
                    SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                }
                if (e instanceof NoSuchPageException) break block4;
                throw new PortletException((Throwable)e);
            }
        }
        return "/wiki/edit_page.jsp";
    }

    protected void getPage(RenderRequest renderRequest) throws Exception {
        WikiPage page;
        boolean removeRedirect;
        block8: {
            WikiNode node;
            long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
            String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title");
            double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
            removeRedirect = ParamUtil.getBoolean((PortletRequest)renderRequest, (String)"removeRedirect");
            if (nodeId == 0L && (node = (WikiNode)renderRequest.getAttribute("WIKI_NODE")) != null) {
                nodeId = node.getNodeId();
            }
            page = null;
            if (Validator.isNull((String)title)) {
                renderRequest.setAttribute("WIKI_PAGE", page);
                return;
            }
            try {
                page = version == 0.0 ? this._wikiPageService.getPage(nodeId, title, null) : this._wikiPageService.getPage(nodeId, title, version);
            }
            catch (NoSuchPageException nspe1) {
                try {
                    page = this._wikiPageService.getPage(nodeId, title, Boolean.valueOf(false));
                }
                catch (NoSuchPageException nspe2) {
                    WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
                    WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
                    if (title.equals(wikiGroupServiceConfiguration.frontPageName()) && version == 0.0) {
                        ServiceContext serviceContext = new ServiceContext();
                        page = this._wikiPageService.addPage(nodeId, title, null, "New", true, serviceContext);
                        break block8;
                    }
                    throw nspe2;
                }
            }
        }
        if (removeRedirect) {
            page.setContent("");
            page.setRedirectTitle("");
        }
        renderRequest.setAttribute("WIKI_PAGE", (Object)page);
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }

    @Reference(unbind="-")
    protected void setWikiPageTitleValidator(WikiPageTitleValidator wikiPageTitleValidator) {
        this._wikiPageTitleValidator = wikiPageTitleValidator;
    }
}

