/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.StrutsActionPortletURL;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.exception.DuplicatePageException;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.PageTitleException;
import com.liferay.wiki.exception.PageVersionException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import com.liferay.wiki.service.WikiPageService;
import com.liferay.wiki.web.internal.WikiAttachmentsHelper;
import com.liferay.wiki.web.internal.util.WikiWebComponentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.filter.ActionResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/edit_page"}, service={MVCActionCommand.class})
public class EditPageMVCActionCommand
extends BaseMVCActionCommand {
    private TrashEntryLocalService _trashEntryLocalService;
    private TrashEntryService _trashEntryService;
    @Reference
    private TrashHelper _trashHelper;
    private WikiAttachmentsHelper _wikiAttachmentsHelper;
    private WikiPageLocalService _wikiPageLocalService;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;
    private WikiPageService _wikiPageService;

    @Reference(unbind="-")
    public void setWikiAttachmentsHelper(WikiAttachmentsHelper wikiAttachmentsHelper) {
        this._wikiAttachmentsHelper = wikiAttachmentsHelper;
    }

    protected void deletePage(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        String[] deletePageTitles = null;
        deletePageTitles = Validator.isNotNull((String)title) ? new String[]{title} : ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"rowIdsWikiPage");
        ArrayList<WikiPage> trashedModels = new ArrayList<WikiPage>();
        for (String deletePageTitle : deletePageTitles) {
            if (moveToTrash) {
                WikiPage trashedWikiPage = null;
                trashedWikiPage = version > 0.0 ? this._wikiPageService.movePageToTrash(nodeId, deletePageTitle, version) : this._wikiPageService.movePageToTrash(nodeId, deletePageTitle);
                trashedModels.add(trashedWikiPage);
                continue;
            }
            if (version > 0.0) {
                this._wikiPageService.discardDraft(nodeId, deletePageTitle, version);
                continue;
            }
            this._wikiPageService.deletePage(nodeId, deletePageTitle);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<WikiPage>> data = new HashMap<String, ArrayList<WikiPage>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        WikiPage page = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                page = this.updatePage(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deletePage(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deletePage(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restorePage(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertPage(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribePage(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribePage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (page != null) {
                    int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
                    if (workflowAction == 2) {
                        redirect = this.getSaveAndContinueRedirect(actionRequest, actionResponse, page, redirect);
                    } else if (redirect.endsWith("title=")) {
                        redirect = redirect + page.getTitle();
                    }
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof NoSuchPageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof DuplicatePageException || e instanceof PageContentException || e instanceof PageTitleException || e instanceof PageVersionException || e instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            Throwable cause = e.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e;
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, WikiPage page, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        while (actionResponse instanceof ActionResponseWrapper) {
            actionResponse = ((ActionResponseWrapper)actionResponse).getResponse();
        }
        StrutsActionPortletURL liferayPortletURL = new StrutsActionPortletURL(LiferayPortletUtil.getLiferayPortletResponse((PortletResponse)actionResponse), themeDisplay.getPlid(), "RENDER_PHASE");
        liferayPortletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        liferayPortletURL.setParameter("cmd", "update", false);
        liferayPortletURL.setParameter("redirect", redirect, false);
        liferayPortletURL.setParameter("groupId", String.valueOf(layout.getGroupId()), false);
        liferayPortletURL.setParameter("nodeId", String.valueOf(page.getNodeId()), false);
        liferayPortletURL.setParameter("title", page.getTitle(), false);
        liferayPortletURL.setWindowState(actionRequest.getWindowState());
        return liferayPortletURL.toString();
    }

    protected void restorePage(ActionRequest actionRequest) throws Exception {
        long[] restoreEntryIds;
        for (long restoreEntryId : restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            WikiPage overridePage;
            WikiWebComponentProvider wikiWebComponentProvider;
            WikiGroupServiceConfiguration wikiGroupServiceConfiguration;
            long overridePageResourcePrimKey = 0L;
            TrashEntry trashEntry = this._trashEntryLocalService.getTrashEntry(restoreEntryId);
            WikiPageResource pageResource = this._wikiPageResourceLocalService.getPageResource(trashEntry.getClassPK());
            String title = this._trashHelper.getOriginalTitle(pageResource.getTitle());
            if (title.equals((wikiGroupServiceConfiguration = (wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider()).getWikiGroupServiceConfiguration()).frontPageName()) && (overridePage = this._wikiPageLocalService.fetchPage(pageResource.getNodeId(), wikiGroupServiceConfiguration.frontPageName())) != null) {
                overridePageResourcePrimKey = overridePage.getResourcePrimKey();
            }
            this._trashEntryService.restoreEntry(restoreEntryId, overridePageResourcePrimKey, null);
        }
    }

    protected void revertPage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        this._wikiPageService.revertPage(nodeId, title, version, serviceContext);
    }

    @Reference(unbind="-")
    protected void setTrashEntryLocalService(TrashEntryLocalService trashEntryLocalService) {
        this._trashEntryLocalService = trashEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }

    protected void subscribePage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        this._wikiPageService.subscribePage(nodeId, title);
    }

    protected void unsubscribePage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        this._wikiPageService.unsubscribePage(nodeId, title);
    }

    protected WikiPage updatePage(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        String summary = ParamUtil.getString((PortletRequest)actionRequest, (String)"summary");
        boolean minorEdit = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"minorEdit");
        String format = ParamUtil.getString((PortletRequest)actionRequest, (String)"format");
        String parentTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"parentTitle");
        String redirectTitle = null;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        WikiPage page = null;
        if (cmd.equals("update")) {
            double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
            page = this._wikiPageService.updatePage(nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
        } else {
            page = this._wikiPageService.addPage(nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
            boolean copyPageAttachments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyPageAttachments");
            if (copyPageAttachments) {
                long templateNodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"templateNodeId");
                String templateTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"templateTitle");
                this._wikiPageService.copyPageAttachments(templateNodeId, templateTitle, page.getNodeId(), page.getTitle());
            }
        }
        this._wikiAttachmentsHelper.addAttachments(actionRequest);
        return page;
    }
}

