/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.wiki.exception.DuplicateNodeNameException;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NodeNameException;
import com.liferay.wiki.exception.RequiredNodeException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiNodeService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "mvc.command.name=/wiki/edit_node"}, service={MVCActionCommand.class})
public class EditNodeMVCActionCommand
extends BaseMVCActionCommand {
    private TrashEntryService _trashEntryService;
    private WikiNodeLocalService _wikiNodeLocalService;
    private WikiNodeService _wikiNodeService;

    protected void deleteNode(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int nodeCount = this._wikiNodeLocalService.getNodesCount(themeDisplay.getScopeGroupId());
        if (nodeCount == 1) {
            SessionErrors.add((PortletRequest)actionRequest, RequiredNodeException.class);
            return;
        }
        ArrayList<WikiNode> trashedModels = new ArrayList<WikiNode>();
        long[] deleteNodeIds = null;
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        deleteNodeIds = nodeId > 0L ? new long[]{nodeId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsWikiNode");
        ModifiableSettings modifiableSettings = this.getModifiableSettings(actionRequest);
        for (long deleteNodeId : deleteNodeIds) {
            WikiNode wikiNode = this._wikiNodeService.getNode(deleteNodeId);
            String oldName = wikiNode.getName();
            if (moveToTrash) {
                WikiNode trashWikiNode = this._wikiNodeService.moveNodeToTrash(deleteNodeId);
                trashedModels.add(trashWikiNode);
            } else {
                this._wikiNodeService.deleteNode(deleteNodeId);
            }
            this.updateSettings(modifiableSettings, oldName, "");
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<WikiNode>> data = new HashMap<String, ArrayList<WikiNode>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateNode(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteNode(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteNode(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeNode(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeNode(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/wiki/error.jsp");
            }
            if (e instanceof DuplicateNodeNameException || e instanceof NodeNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    protected ModifiableSettings getModifiableSettings(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletInstanceSettingsLocator portletInstanceSettingsLocator = new PortletInstanceSettingsLocator(themeDisplay.getLayout(), portletDisplay.getId());
        Settings settings = portletInstanceSettingsLocator.getSettings();
        return settings.getModifiableSettings();
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }

    protected void subscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        this._wikiNodeService.subscribeNode(nodeId);
    }

    protected void unsubscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        this._wikiNodeService.unsubscribeNode(nodeId);
    }

    protected void updateNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)actionRequest);
        if (nodeId <= 0L) {
            this._wikiNodeService.addNode(name, description, serviceContext);
        } else {
            WikiNode wikiNode = this._wikiNodeService.getNode(nodeId);
            String oldName = wikiNode.getName();
            this._wikiNodeService.updateNode(nodeId, name, description, serviceContext);
            ModifiableSettings modifiableSettings = this.getModifiableSettings(actionRequest);
            this.updateSettings(modifiableSettings, oldName, name);
        }
    }

    protected void updateSettings(ModifiableSettings modifiableSettings, String oldName, String newName) throws Exception {
        String[] hiddenNodes = modifiableSettings.getValues("hiddenNodes", null);
        if (hiddenNodes != null) {
            if (newName.isEmpty()) {
                ArrayUtil.remove((String[])hiddenNodes, (String)oldName);
            } else {
                ArrayUtil.replace((String[])hiddenNodes, (String)oldName, (String)newName);
            }
            modifiableSettings.setValues("hiddenNodes", hiddenNodes);
        }
        if (hiddenNodes != null) {
            String[] visibleNodes = modifiableSettings.getValues("visibleNodes", null);
            if (newName.isEmpty()) {
                ArrayUtil.remove((String[])visibleNodes, (String)oldName);
            } else {
                ArrayUtil.replace((String[])visibleNodes, (String)oldName, (String)newName);
            }
            modifiableSettings.setValues("visibleNodes", visibleNodes);
        }
        modifiableSettings.store();
    }
}

