/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiNodeServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.service.WikiPageServiceUtil;
import com.liferay.wiki.web.configuration.WikiPortletInstanceConfiguration;
import com.liferay.wiki.web.internal.security.permission.resource.WikiNodePermission;
import com.liferay.wiki.web.internal.util.WikiUtil;
import com.liferay.wiki.web.internal.util.WikiWebComponentProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void compareVersions(RenderRequest renderRequest, RenderResponse renderResponse, WikiEngineRenderer wikiEngineRenderer) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title");
        double sourceVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"sourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"targetVersion");
        String htmlDiffResult = ActionUtil.getHtmlDiffResult(sourceVersion, targetVersion, (PortletRequest)renderRequest, (PortletResponse)renderResponse, wikiEngineRenderer);
        renderRequest.setAttribute("DIFF_HTML_RESULTS", (Object)htmlDiffResult);
        renderRequest.setAttribute("SOURCE_VERSION", (Object)sourceVersion);
        renderRequest.setAttribute("TARGET_VERSION", (Object)targetVersion);
        renderRequest.setAttribute("TITLE", (Object)title);
        renderRequest.setAttribute("WIKI_NODE_ID", (Object)nodeId);
    }

    public static WikiNode getFirstNode(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List<WikiNode> nodes = WikiNodeLocalServiceUtil.getNodes((long)groupId);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = (WikiPortletInstanceConfiguration)ConfigurationProviderUtil.getConfiguration(WikiPortletInstanceConfiguration.class, (SettingsLocator)new PortletInstanceSettingsLocator(themeDisplay.getLayout(), portletDisplay.getId()));
        String[] visibleNodeNames = wikiPortletInstanceConfiguration.visibleNodes();
        nodes = WikiUtil.orderNodes(nodes, visibleNodeNames);
        Object[] hiddenNodes = wikiPortletInstanceConfiguration.hiddenNodes();
        Arrays.sort(hiddenNodes);
        for (WikiNode node : nodes) {
            if (Arrays.binarySearch(hiddenNodes, node.getName()) >= 0 || !WikiNodePermission.contains(permissionChecker, node, "VIEW")) continue;
            return node;
        }
        return null;
    }

    public static WikiNode getFirstVisibleNode(PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        WikiNode node = null;
        int nodesCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodesCount == 0) {
            Layout layout = themeDisplay.getLayout();
            serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)portletRequest);
            serviceContext.setAddGroupPermissions(true);
            if (layout.isPublicLayout() || layout.isTypeControlPanel()) {
                serviceContext.setAddGuestPermissions(true);
            } else {
                serviceContext.setAddGuestPermissions(false);
            }
        } else {
            node = ActionUtil.getFirstNode(portletRequest);
            if (node == null) {
                throw new PrincipalException();
            }
            return node;
        }
        node = WikiNodeLocalServiceUtil.addDefaultNode((long)themeDisplay.getDefaultUserId(), (ServiceContext)serviceContext);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiPage getFirstVisiblePage(long nodeId, PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
        WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)nodeId, (String)wikiGroupServiceConfiguration.frontPageName(), (double)0.0);
        if (page == null) {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)portletRequest);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAddGroupPermissions(true);
            boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
            try {
                WorkflowThreadLocal.setEnabled((boolean)false);
                page = WikiPageLocalServiceUtil.addPage((long)themeDisplay.getDefaultUserId(), (long)nodeId, (String)wikiGroupServiceConfiguration.frontPageName(), null, (String)"New", (boolean)true, (ServiceContext)serviceContext);
            }
            finally {
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return page;
    }

    public static String getHtmlDiffResult(double sourceVersion, double targetVersion, PortletRequest portletRequest, PortletResponse portletResponse, WikiEngineRenderer wikiEngineRenderer) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)portletRequest, (String)"title");
        WikiPage sourcePage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)sourceVersion);
        WikiPage targetPage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)targetVersion);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
        PortletURL viewPageURL = liferayPortletResponse.createRenderURL();
        viewPageURL.setParameter("mvcRenderCommandName", "wiki/view");
        WikiNode sourceNode = sourcePage.getNode();
        viewPageURL.setParameter("nodeName", sourceNode.getName());
        PortletURL editPageURL = liferayPortletResponse.createRenderURL();
        editPageURL.setParameter("mvcRenderCommandName", "wiki/edit_page");
        editPageURL.setParameter("nodeId", String.valueOf(nodeId));
        editPageURL.setParameter("title", title);
        String attachmentURLPrefix = WikiUtil.getAttachmentURLPrefix(themeDisplay.getPathMain(), themeDisplay.getPlid(), nodeId, title);
        return wikiEngineRenderer.diffHtml(sourcePage, targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public static WikiNode getNode(PortletRequest portletRequest) throws Exception {
        WikiNode node;
        block4: {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long nodeId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"nodeId");
            String nodeName = ParamUtil.getString((PortletRequest)portletRequest, (String)"nodeName");
            node = null;
            try {
                if (nodeId > 0L) {
                    node = WikiNodeServiceUtil.getNode((long)nodeId);
                    break block4;
                }
                if (Validator.isNotNull((String)nodeName)) {
                    node = WikiNodeServiceUtil.getNode((long)themeDisplay.getScopeGroupId(), (String)nodeName);
                    break block4;
                }
                throw new NoSuchNodeException();
            }
            catch (NoSuchNodeException nsne) {
                node = ActionUtil.getFirstVisibleNode(portletRequest);
            }
        }
        return node;
    }

    public static List<WikiNode> getNodes(PortletRequest portletRequest) throws PortalException {
        long[] nodeIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIdsWikiNode");
        if (nodeIds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<WikiNode> nodes = new ArrayList<WikiNode>();
        for (long nodeId : nodeIds) {
            if (nodeId == 0L) continue;
            nodes.add(WikiNodeServiceUtil.getNode((long)nodeId));
        }
        return nodes;
    }

    public static WikiPage getPage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
        WikiNode node = null;
        try {
            if (nodeId > 0L) {
                node = WikiNodeServiceUtil.getNode((long)nodeId);
            }
        }
        catch (NoSuchNodeException noSuchNodeException) {
            // empty catch block
        }
        if (node == null && (node = (WikiNode)request.getAttribute("WIKI_NODE")) != null) {
            nodeId = node.getNodeId();
        }
        WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
        WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
        if (Validator.isNull((String)title)) {
            title = wikiGroupServiceConfiguration.frontPageName();
        }
        try {
            return WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
        }
        catch (NoSuchPageException nspe) {
            if (title.equals(wikiGroupServiceConfiguration.frontPageName()) && version == 0.0) {
                return ActionUtil.getFirstVisiblePage(nodeId, portletRequest);
            }
            throw nspe;
        }
    }

    public static List<WikiPage> getPages(PortletRequest portletRequest) throws PortalException {
        String[] titles = ParamUtil.getStringValues((PortletRequest)portletRequest, (String)"rowIdsWikiPage");
        if (titles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        long nodeId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"nodeId");
        for (String title : titles) {
            if (!Validator.isNotNull((String)title)) continue;
            pages.add(WikiPageServiceUtil.getPage((long)nodeId, (String)title));
        }
        return pages;
    }

    public static String viewNode(RenderRequest renderRequest, String defaultForward) throws PortletException {
        try {
            WikiNode node = ActionUtil.getNode((PortletRequest)renderRequest);
            renderRequest.setAttribute("WIKI_NODE", (Object)node);
            ActionUtil.getFirstVisiblePage(node.getNodeId(), (PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/wiki/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        long categoryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"categoryId");
        String tag = ParamUtil.getString((PortletRequest)renderRequest, (String)"tag");
        if (categoryId > 0L || Validator.isNotNull((String)tag)) {
            return "/wiki/view_categorized_pages.jsp";
        }
        return defaultForward;
    }
}

