/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context.logic;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.web.internal.display.context.logic.WikiPortletInstanceSettingsHelper;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import java.util.List;

public class WikiVisualizationHelper {
    private final WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private final WikiPortletInstanceSettingsHelper _wikiPortletInstanceSettingsHelper;
    private final WikiRequestHelper _wikiRequestHelper;

    public WikiVisualizationHelper(WikiRequestHelper wikiRequestHelper, WikiPortletInstanceSettingsHelper wikiPortletInstanceSettingsHelper, WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiRequestHelper = wikiRequestHelper;
        this._wikiPortletInstanceSettingsHelper = wikiPortletInstanceSettingsHelper;
        this._wikiGroupServiceConfiguration = wikiGroupServiceConfiguration;
    }

    public boolean isFrontPageNavItemSelected() {
        WikiPage wikiPage = this._wikiRequestHelper.getWikiPage();
        String mvcRenderCommandName = this._wikiRequestHelper.getMVCrenderCommandName();
        String frontPageName = this._wikiGroupServiceConfiguration.frontPageName();
        return Validator.isNull((String)mvcRenderCommandName) || mvcRenderCommandName.equals("/wiki/view") || mvcRenderCommandName.equals("/wiki/view_page_activities") || mvcRenderCommandName.equals("/wiki/view_page_attachments") || mvcRenderCommandName.equals("/wiki/view_page_details") || mvcRenderCommandName.equals("/wiki/view_page_incoming_links") || mvcRenderCommandName.equals("/wiki/view_page_outgoing_links") || wikiPage != null && frontPageName.equals(wikiPage.getTitle());
    }

    public boolean isNodeNavigationVisible() throws PortalException {
        List<WikiNode> nodes = this._wikiPortletInstanceSettingsHelper.getAllPermittedNodes();
        String portletId = this._wikiRequestHelper.getPortletId();
        return nodes.size() > 1 && portletId.equals("com_liferay_wiki_web_portlet_WikiPortlet");
    }

    public boolean isUndoTrashControlVisible() {
        String mvcRenderCommandName = this._wikiRequestHelper.getMVCrenderCommandName();
        return !mvcRenderCommandName.equals("/wiki/view_page_activities") && !mvcRenderCommandName.equals("/wiki/view_page_attachments");
    }

    public boolean isViewAllPagesNavItemSelected() {
        return this.isNavItemSelected("/wiki/view_pages");
    }

    public boolean isViewDraftPagesNavItemSelected() {
        return this.isNavItemSelected("/wiki/view_draft_pages");
    }

    public boolean isViewOrphanPagesNavItemSelected() {
        return this.isNavItemSelected("/wiki/view_orphan_pages");
    }

    public boolean isViewRecentChangesNavItemSelected() {
        return this.isNavItemSelected("/wiki/view_recent_changes");
    }

    protected boolean isNavItemSelected(String navItemMVCRenderCommandName) {
        String mvcRenderCommandName = this._wikiRequestHelper.getMVCrenderCommandName();
        return mvcRenderCommandName.equals(navItemMVCRenderCommandName);
    }
}

