/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context.logic;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiNodeModel;
import com.liferay.wiki.service.WikiNodeServiceUtil;
import com.liferay.wiki.web.configuration.WikiPortletInstanceConfiguration;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import com.liferay.wiki.web.internal.util.WikiUtil;
import java.util.List;

public class WikiPortletInstanceSettingsHelper {
    private List<String> _allNodeNames;
    private List<WikiNode> _allNodes;
    private List<WikiNode> _allPermittedNodes;
    private String _displayStyle;
    private long _displayStyleGroupId;
    private Boolean _enableCommentRatings;
    private Boolean _enableComments;
    private Boolean _enableHighlighting;
    private Boolean _enablePageRatings;
    private Boolean _enableRelatedAssets;
    private String[] _hiddenNodes;
    private String[] _visibleNodeNames;
    private final WikiRequestHelper _wikiRequestHelper;

    public WikiPortletInstanceSettingsHelper(WikiRequestHelper wikiRequestHelper) {
        this._wikiRequestHelper = wikiRequestHelper;
    }

    public List<String> getAllNodeNames() throws PortalException {
        if (this._allNodeNames == null) {
            this._populateNodes();
        }
        return this._allNodeNames;
    }

    public List<WikiNode> getAllNodes() throws PortalException {
        if (this._allNodes == null) {
            this._populateNodes();
        }
        return this._allNodes;
    }

    public List<WikiNode> getAllPermittedNodes() throws PortalException {
        if (this._allPermittedNodes == null) {
            WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
            this._allPermittedNodes = WikiUtil.getNodes(this.getAllNodes(), wikiPortletInstanceConfiguration.hiddenNodes(), this._wikiRequestHelper.getPermissionChecker());
        }
        return this._allPermittedNodes;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._displayStyle = wikiPortletInstanceConfiguration.displayStyle();
        return this._displayStyle;
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != 0L) {
            return this._displayStyleGroupId;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._displayStyleGroupId = wikiPortletInstanceConfiguration.displayStyleGroupId();
        if (this._displayStyleGroupId <= 0L) {
            ThemeDisplay themeDisplay = this._wikiRequestHelper.getThemeDisplay();
            this._displayStyleGroupId = themeDisplay.getScopeGroupId();
        }
        return this._displayStyleGroupId;
    }

    public String[] getHiddenNodes() {
        if (this._hiddenNodes != null) {
            return this._hiddenNodes;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._hiddenNodes = wikiPortletInstanceConfiguration.hiddenNodes();
        return this._hiddenNodes;
    }

    public String[] getVisibleNodeNames() throws PortalException {
        if (this._visibleNodeNames == null) {
            this._populateNodes();
        }
        return this._visibleNodeNames;
    }

    public Boolean isEnableCommentRatings() {
        if (this._enableCommentRatings != null) {
            return this._enableCommentRatings;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._enableCommentRatings = wikiPortletInstanceConfiguration.enableCommentRatings();
        return this._enableCommentRatings;
    }

    public Boolean isEnableComments() {
        if (this._enableComments != null) {
            return this._enableComments;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._enableComments = wikiPortletInstanceConfiguration.enableComments();
        return this._enableComments;
    }

    public Boolean isEnableHighlighting() {
        if (this._enableHighlighting != null) {
            return this._enableHighlighting;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._enableHighlighting = wikiPortletInstanceConfiguration.enableHighlighting();
        return this._enableHighlighting;
    }

    public Boolean isEnablePageRatings() {
        if (this._enablePageRatings != null) {
            return this._enablePageRatings;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._enablePageRatings = wikiPortletInstanceConfiguration.enablePageRatings();
        return this._enablePageRatings;
    }

    public boolean isEnableRelatedAssets() {
        if (this._enableRelatedAssets != null) {
            return this._enableRelatedAssets;
        }
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._enableRelatedAssets = wikiPortletInstanceConfiguration.enableRelatedAssets();
        return this._enableRelatedAssets;
    }

    private void _populateNodes() throws PortalException {
        this._allNodes = WikiNodeServiceUtil.getNodes((long)this._wikiRequestHelper.getScopeGroupId());
        this._allNodeNames = ListUtil.toList(this._allNodes, WikiNodeModel::getName);
        WikiPortletInstanceConfiguration wikiPortletInstanceConfiguration = this._wikiRequestHelper.getWikiPortletInstanceConfiguration();
        this._visibleNodeNames = wikiPortletInstanceConfiguration.visibleNodes();
        if (ArrayUtil.isNotEmpty((Object[])this._visibleNodeNames)) {
            this._allNodes = WikiUtil.orderNodes(this._allNodes, this._visibleNodeNames);
        } else {
            this._visibleNodeNames = this._allNodeNames.toArray(new String[this._allNodeNames.size()]);
        }
    }
}

