/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context.logic;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class MailTemplatesHelper {
    private final WikiGroupServiceOverriddenConfiguration _wikiGroupServiceOverriddenConfiguration;
    private final WikiRequestHelper _wikiRequestHelper;

    public MailTemplatesHelper(WikiRequestHelper wikiRequestHelper) {
        this._wikiRequestHelper = wikiRequestHelper;
        this._wikiGroupServiceOverriddenConfiguration = wikiRequestHelper.getWikiGroupServiceOverriddenConfiguration();
    }

    public Map<String, String> getEmailFromDefinitionTerms() {
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        ResourceBundle resourceBundle = this.getResourceBundle();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-id-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-mx-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-name-associated-with-the-wiki"));
        definitionTerms.put("[$PAGE_USER_ADDRESS$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-email-address-of-the-user-who-added-the-page"));
        definitionTerms.put("[$PAGE_USER_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-user-who-added-the-page"));
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)this._wikiRequestHelper.getPortletTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-site-name-associated-with-the-wiki"));
        return definitionTerms;
    }

    public Map<String, String> getEmailNotificationDefinitionTerms() {
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        ResourceBundle resourceBundle = this.getResourceBundle();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-id-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-mx-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-company-name-associated-with-the-wiki"));
        definitionTerms.put("[$DIFFS_URL$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-url-of-the-page-comparing-this-page-content-with-the-previous-version"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)this._wikiGroupServiceOverriddenConfiguration.emailFromAddress()));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)this._wikiGroupServiceOverriddenConfiguration.emailFromName()));
        definitionTerms.put("[$NODE_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-node-in-which-the-page-was-added"));
        definitionTerms.put("[$PAGE_CONTENT$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-page-content"));
        definitionTerms.put("[$PAGE_DATE_UPDATE$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-date-of-the-modifications"));
        definitionTerms.put("[$PAGE_DIFFS$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-page-content-compared-with-the-previous-version-page-content"));
        definitionTerms.put("[$PAGE_ID$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-page-id"));
        definitionTerms.put("[$PAGE_SUMMARY$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-summary-of-the-page-or-the-modifications"));
        definitionTerms.put("[$PAGE_TITLE$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-page-title"));
        definitionTerms.put("[$PAGE_URL$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-page-url"));
        definitionTerms.put("[$PAGE_USER_ADDRESS$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-email-address-of-the-user-who-added-the-page"));
        definitionTerms.put("[$PAGE_USER_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-user-who-added-the-page"));
        Company company = this._wikiRequestHelper.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", this._wikiRequestHelper.getPortletTitle());
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-site-name-associated-with-the-wiki"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    protected ResourceBundle getResourceBundle() {
        ResourceBundle bundleResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._wikiRequestHelper.getLocale(), this.getClass());
        ResourceBundle portalResourceBundle = LanguageResources.getResourceBundle((Locale)this._wikiRequestHelper.getLocale());
        return new AggregateResourceBundle(new ResourceBundle[]{bundleResourceBundle, portalResourceBundle});
    }
}

